// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/ai/assistants/v1/searchindex/search_index.proto

package searchindex

import (
	common "github.com/yandex-cloud/go-genproto/yandex/cloud/ai/common"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents a search index used to store and query data, either using traditional keyword-based text search or vector-based search mechanisms.
type SearchIndex struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique identifier of the search index.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the search index belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the search index.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the search index.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the subject who created this search index.
	CreatedBy string `protobuf:"bytes,5,opt,name=created_by,json=createdBy,proto3" json:"created_by,omitempty"`
	// Timestamp representing when the search index was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Identifier of the subject who last updated this search index.
	UpdatedBy string `protobuf:"bytes,7,opt,name=updated_by,json=updatedBy,proto3" json:"updated_by,omitempty"`
	// Timestamp representing the last time this search index was updated.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Configuration for the expiration of the search index, defining when and how the search index will expire.
	ExpirationConfig *common.ExpirationConfig `protobuf:"bytes,9,opt,name=expiration_config,json=expirationConfig,proto3" json:"expiration_config,omitempty"`
	// Timestamp representing when the search index will expire.
	ExpiresAt *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// Set of key-value pairs that can be used to organize and categorize the search index.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Type of the search index. It can be either a traditional keyword-based text search or a vector-based search.
	//
	// Types that are valid to be assigned to IndexType:
	//
	//	*SearchIndex_TextSearchIndex
	//	*SearchIndex_VectorSearchIndex
	//	*SearchIndex_HybridSearchIndex
	IndexType     isSearchIndex_IndexType `protobuf_oneof:"IndexType"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SearchIndex) Reset() {
	*x = SearchIndex{}
	mi := &file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchIndex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchIndex) ProtoMessage() {}

func (x *SearchIndex) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchIndex.ProtoReflect.Descriptor instead.
func (*SearchIndex) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescGZIP(), []int{0}
}

func (x *SearchIndex) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SearchIndex) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *SearchIndex) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchIndex) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SearchIndex) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

func (x *SearchIndex) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *SearchIndex) GetUpdatedBy() string {
	if x != nil {
		return x.UpdatedBy
	}
	return ""
}

func (x *SearchIndex) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *SearchIndex) GetExpirationConfig() *common.ExpirationConfig {
	if x != nil {
		return x.ExpirationConfig
	}
	return nil
}

func (x *SearchIndex) GetExpiresAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiresAt
	}
	return nil
}

func (x *SearchIndex) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *SearchIndex) GetIndexType() isSearchIndex_IndexType {
	if x != nil {
		return x.IndexType
	}
	return nil
}

func (x *SearchIndex) GetTextSearchIndex() *TextSearchIndex {
	if x != nil {
		if x, ok := x.IndexType.(*SearchIndex_TextSearchIndex); ok {
			return x.TextSearchIndex
		}
	}
	return nil
}

func (x *SearchIndex) GetVectorSearchIndex() *VectorSearchIndex {
	if x != nil {
		if x, ok := x.IndexType.(*SearchIndex_VectorSearchIndex); ok {
			return x.VectorSearchIndex
		}
	}
	return nil
}

func (x *SearchIndex) GetHybridSearchIndex() *HybridSearchIndex {
	if x != nil {
		if x, ok := x.IndexType.(*SearchIndex_HybridSearchIndex); ok {
			return x.HybridSearchIndex
		}
	}
	return nil
}

type isSearchIndex_IndexType interface {
	isSearchIndex_IndexType()
}

type SearchIndex_TextSearchIndex struct {
	// Keyword-based text search index configuration.
	// This type of index is used for traditional text search, where documents are indexed based on their keywords.
	TextSearchIndex *TextSearchIndex `protobuf:"bytes,12,opt,name=text_search_index,json=textSearchIndex,proto3,oneof"`
}

type SearchIndex_VectorSearchIndex struct {
	// Vector-based search index configuration.
	// This type is used for vector search, where documents are indexed using vector embeddings.
	VectorSearchIndex *VectorSearchIndex `protobuf:"bytes,13,opt,name=vector_search_index,json=vectorSearchIndex,proto3,oneof"`
}

type SearchIndex_HybridSearchIndex struct {
	// Hybrid (vector-based + keyword-based) search index configuration
	// This type is used for hybrid search, where documents are indexed using both keyword-based and vector-based search mechanisms.
	HybridSearchIndex *HybridSearchIndex `protobuf:"bytes,14,opt,name=hybrid_search_index,json=hybridSearchIndex,proto3,oneof"`
}

func (*SearchIndex_TextSearchIndex) isSearchIndex_IndexType() {}

func (*SearchIndex_VectorSearchIndex) isSearchIndex_IndexType() {}

func (*SearchIndex_HybridSearchIndex) isSearchIndex_IndexType() {}

// Defines the configuration for a traditional keyword-based text search index.
type TextSearchIndex struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Chunking strategy used to split text into smaller chunks before indexing.
	// In the case of text search, tokens are individual text characters.
	ChunkingStrategy *ChunkingStrategy `protobuf:"bytes,1,opt,name=chunking_strategy,json=chunkingStrategy,proto3" json:"chunking_strategy,omitempty"`
	// Tokenizer type used for text search. The tokenizer determines how the
	// input text is broken down into tokens before indexing.
	// If not specified, the default tokenizer configuration is applied.
	//
	// Types that are valid to be assigned to TextTokenizer:
	//
	//	*TextSearchIndex_NgramTokenizer
	//	*TextSearchIndex_StandardTokenizer
	TextTokenizer isTextSearchIndex_TextTokenizer `protobuf_oneof:"TextTokenizer"`
	// Analyzer type used for text search. The analyzer determines how the
	// tokenized text is further processed before indexing.
	// If not specified, the default analyzer configuration is applied.
	//
	// Types that are valid to be assigned to TextAnalyzer:
	//
	//	*TextSearchIndex_StandardAnalyzer
	//	*TextSearchIndex_YandexLemmerAnalyzer
	TextAnalyzer  isTextSearchIndex_TextAnalyzer `protobuf_oneof:"TextAnalyzer"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TextSearchIndex) Reset() {
	*x = TextSearchIndex{}
	mi := &file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TextSearchIndex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSearchIndex) ProtoMessage() {}

func (x *TextSearchIndex) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSearchIndex.ProtoReflect.Descriptor instead.
func (*TextSearchIndex) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescGZIP(), []int{1}
}

func (x *TextSearchIndex) GetChunkingStrategy() *ChunkingStrategy {
	if x != nil {
		return x.ChunkingStrategy
	}
	return nil
}

func (x *TextSearchIndex) GetTextTokenizer() isTextSearchIndex_TextTokenizer {
	if x != nil {
		return x.TextTokenizer
	}
	return nil
}

// Deprecated: Marked as deprecated in yandex/cloud/ai/assistants/v1/searchindex/search_index.proto.
func (x *TextSearchIndex) GetNgramTokenizer() *NgramTokenizer {
	if x != nil {
		if x, ok := x.TextTokenizer.(*TextSearchIndex_NgramTokenizer); ok {
			return x.NgramTokenizer
		}
	}
	return nil
}

func (x *TextSearchIndex) GetStandardTokenizer() *StandardTokenizer {
	if x != nil {
		if x, ok := x.TextTokenizer.(*TextSearchIndex_StandardTokenizer); ok {
			return x.StandardTokenizer
		}
	}
	return nil
}

func (x *TextSearchIndex) GetTextAnalyzer() isTextSearchIndex_TextAnalyzer {
	if x != nil {
		return x.TextAnalyzer
	}
	return nil
}

func (x *TextSearchIndex) GetStandardAnalyzer() *StandardAnalyzer {
	if x != nil {
		if x, ok := x.TextAnalyzer.(*TextSearchIndex_StandardAnalyzer); ok {
			return x.StandardAnalyzer
		}
	}
	return nil
}

func (x *TextSearchIndex) GetYandexLemmerAnalyzer() *YandexLemmerAnalyzer {
	if x != nil {
		if x, ok := x.TextAnalyzer.(*TextSearchIndex_YandexLemmerAnalyzer); ok {
			return x.YandexLemmerAnalyzer
		}
	}
	return nil
}

type isTextSearchIndex_TextTokenizer interface {
	isTextSearchIndex_TextTokenizer()
}

type TextSearchIndex_NgramTokenizer struct {
	// Tokenizer that generates n-grams.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/ai/assistants/v1/searchindex/search_index.proto.
	NgramTokenizer *NgramTokenizer `protobuf:"bytes,2,opt,name=ngram_tokenizer,json=ngramTokenizer,proto3,oneof"`
}

type TextSearchIndex_StandardTokenizer struct {
	// Tokenizer that generates words.
	StandardTokenizer *StandardTokenizer `protobuf:"bytes,3,opt,name=standard_tokenizer,json=standardTokenizer,proto3,oneof"`
}

func (*TextSearchIndex_NgramTokenizer) isTextSearchIndex_TextTokenizer() {}

func (*TextSearchIndex_StandardTokenizer) isTextSearchIndex_TextTokenizer() {}

type isTextSearchIndex_TextAnalyzer interface {
	isTextSearchIndex_TextAnalyzer()
}

type TextSearchIndex_StandardAnalyzer struct {
	// Standard analyzer that performs common text processing operations to normalize text.
	StandardAnalyzer *StandardAnalyzer `protobuf:"bytes,4,opt,name=standard_analyzer,json=standardAnalyzer,proto3,oneof"`
}

type TextSearchIndex_YandexLemmerAnalyzer struct {
	// Specialized analyzer that uses Yandex's lemmatization technology,
	// particularly effective for Russian and other Slavic languages.
	YandexLemmerAnalyzer *YandexLemmerAnalyzer `protobuf:"bytes,5,opt,name=yandex_lemmer_analyzer,json=yandexLemmerAnalyzer,proto3,oneof"`
}

func (*TextSearchIndex_StandardAnalyzer) isTextSearchIndex_TextAnalyzer() {}

func (*TextSearchIndex_YandexLemmerAnalyzer) isTextSearchIndex_TextAnalyzer() {}

// Defines the configuration for a vector-based search index. This type uses embeddings to represent documents and queries.
type VectorSearchIndex struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The [ID of the model](/docs/foundation-models/concepts/embeddings) to be used for obtaining document text embeddings.
	DocEmbedderUri string `protobuf:"bytes,1,opt,name=doc_embedder_uri,json=docEmbedderUri,proto3" json:"doc_embedder_uri,omitempty"`
	// The [ID of the model](/docs/foundation-models/concepts/embeddings) to be used for obtaining query text embeddings.
	QueryEmbedderUri string `protobuf:"bytes,2,opt,name=query_embedder_uri,json=queryEmbedderUri,proto3" json:"query_embedder_uri,omitempty"`
	// Chunking strategy used to split text into smaller chunks before indexing.
	// In the case of vector search, tokens are produced by the tokenizer from the embedding model.
	ChunkingStrategy *ChunkingStrategy `protobuf:"bytes,3,opt,name=chunking_strategy,json=chunkingStrategy,proto3" json:"chunking_strategy,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *VectorSearchIndex) Reset() {
	*x = VectorSearchIndex{}
	mi := &file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VectorSearchIndex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VectorSearchIndex) ProtoMessage() {}

func (x *VectorSearchIndex) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VectorSearchIndex.ProtoReflect.Descriptor instead.
func (*VectorSearchIndex) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescGZIP(), []int{2}
}

func (x *VectorSearchIndex) GetDocEmbedderUri() string {
	if x != nil {
		return x.DocEmbedderUri
	}
	return ""
}

func (x *VectorSearchIndex) GetQueryEmbedderUri() string {
	if x != nil {
		return x.QueryEmbedderUri
	}
	return ""
}

func (x *VectorSearchIndex) GetChunkingStrategy() *ChunkingStrategy {
	if x != nil {
		return x.ChunkingStrategy
	}
	return nil
}

// Defines the configuration for a hybrid (vector-based + keyword-based) search index. This type uses both embeddings and keyword-based search to represent documents and queries.
type HybridSearchIndex struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for a traditional keyword-based text search index.
	TextSearchIndex *TextSearchIndex `protobuf:"bytes,1,opt,name=text_search_index,json=textSearchIndex,proto3" json:"text_search_index,omitempty"`
	// Configuration for a vector-based search index.
	VectorSearchIndex *VectorSearchIndex `protobuf:"bytes,2,opt,name=vector_search_index,json=vectorSearchIndex,proto3" json:"vector_search_index,omitempty"`
	// Common chunking strategy that applies to both text and vector search indexes.
	// If provided, it overrides the individual chunking strategies in both `text_search_index` and `vector_search_index`.
	// In this case, both text and vector search will use token-based chunking, where tokens are produced by the tokenizer of the embedding model.
	ChunkingStrategy *ChunkingStrategy `protobuf:"bytes,3,opt,name=chunking_strategy,json=chunkingStrategy,proto3" json:"chunking_strategy,omitempty"`
	// Normalization strategy for relevance scores from different indices. Default is MIN_MAX_STRATEGY
	NormalizationStrategy NormalizationStrategy `protobuf:"varint,4,opt,name=normalization_strategy,json=normalizationStrategy,proto3,enum=yandex.cloud.ai.assistants.v1.searchindex.NormalizationStrategy" json:"normalization_strategy,omitempty"`
	// Combination strategy for merging rankings from different indices. Default is arithmetic mean
	CombinationStrategy *CombinationStrategy `protobuf:"bytes,5,opt,name=combination_strategy,json=combinationStrategy,proto3" json:"combination_strategy,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *HybridSearchIndex) Reset() {
	*x = HybridSearchIndex{}
	mi := &file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HybridSearchIndex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridSearchIndex) ProtoMessage() {}

func (x *HybridSearchIndex) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridSearchIndex.ProtoReflect.Descriptor instead.
func (*HybridSearchIndex) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescGZIP(), []int{3}
}

func (x *HybridSearchIndex) GetTextSearchIndex() *TextSearchIndex {
	if x != nil {
		return x.TextSearchIndex
	}
	return nil
}

func (x *HybridSearchIndex) GetVectorSearchIndex() *VectorSearchIndex {
	if x != nil {
		return x.VectorSearchIndex
	}
	return nil
}

func (x *HybridSearchIndex) GetChunkingStrategy() *ChunkingStrategy {
	if x != nil {
		return x.ChunkingStrategy
	}
	return nil
}

func (x *HybridSearchIndex) GetNormalizationStrategy() NormalizationStrategy {
	if x != nil {
		return x.NormalizationStrategy
	}
	return NormalizationStrategy_NORMALIZATION_STRATEGY_UNSPECIFIED
}

func (x *HybridSearchIndex) GetCombinationStrategy() *CombinationStrategy {
	if x != nil {
		return x.CombinationStrategy
	}
	return nil
}

var File_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto protoreflect.FileDescriptor

const file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDesc = "" +
	"\n" +
	"<yandex/cloud/ai/assistants/v1/searchindex/search_index.proto\x12)yandex.cloud.ai.assistants.v1.searchindex\x1a#yandex/cloud/ai/common/common.proto\x1a6yandex/cloud/ai/assistants/v1/searchindex/common.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xa4\a\n" +
	"\vSearchIndex\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x04 \x01(\tR\vdescription\x12\x1d\n" +
	"\n" +
	"created_by\x18\x05 \x01(\tR\tcreatedBy\x129\n" +
	"\n" +
	"created_at\x18\x06 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x1d\n" +
	"\n" +
	"updated_by\x18\a \x01(\tR\tupdatedBy\x129\n" +
	"\n" +
	"updated_at\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\tupdatedAt\x12U\n" +
	"\x11expiration_config\x18\t \x01(\v2(.yandex.cloud.ai.common.ExpirationConfigR\x10expirationConfig\x129\n" +
	"\n" +
	"expires_at\x18\n" +
	" \x01(\v2\x1a.google.protobuf.TimestampR\texpiresAt\x12Z\n" +
	"\x06labels\x18\v \x03(\v2B.yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.LabelsEntryR\x06labels\x12h\n" +
	"\x11text_search_index\x18\f \x01(\v2:.yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndexH\x00R\x0ftextSearchIndex\x12n\n" +
	"\x13vector_search_index\x18\r \x01(\v2<.yandex.cloud.ai.assistants.v1.searchindex.VectorSearchIndexH\x00R\x11vectorSearchIndex\x12n\n" +
	"\x13hybrid_search_index\x18\x0e \x01(\v2<.yandex.cloud.ai.assistants.v1.searchindex.HybridSearchIndexH\x00R\x11hybridSearchIndex\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\v\n" +
	"\tIndexType\"\xda\x04\n" +
	"\x0fTextSearchIndex\x12h\n" +
	"\x11chunking_strategy\x18\x01 \x01(\v2;.yandex.cloud.ai.assistants.v1.searchindex.ChunkingStrategyR\x10chunkingStrategy\x12h\n" +
	"\x0fngram_tokenizer\x18\x02 \x01(\v29.yandex.cloud.ai.assistants.v1.searchindex.NgramTokenizerB\x02\x18\x01H\x00R\x0engramTokenizer\x12m\n" +
	"\x12standard_tokenizer\x18\x03 \x01(\v2<.yandex.cloud.ai.assistants.v1.searchindex.StandardTokenizerH\x00R\x11standardTokenizer\x12j\n" +
	"\x11standard_analyzer\x18\x04 \x01(\v2;.yandex.cloud.ai.assistants.v1.searchindex.StandardAnalyzerH\x01R\x10standardAnalyzer\x12w\n" +
	"\x16yandex_lemmer_analyzer\x18\x05 \x01(\v2?.yandex.cloud.ai.assistants.v1.searchindex.YandexLemmerAnalyzerH\x01R\x14yandexLemmerAnalyzerB\x0f\n" +
	"\rTextTokenizerB\x0e\n" +
	"\fTextAnalyzer\"\xd5\x01\n" +
	"\x11VectorSearchIndex\x12(\n" +
	"\x10doc_embedder_uri\x18\x01 \x01(\tR\x0edocEmbedderUri\x12,\n" +
	"\x12query_embedder_uri\x18\x02 \x01(\tR\x10queryEmbedderUri\x12h\n" +
	"\x11chunking_strategy\x18\x03 \x01(\v2;.yandex.cloud.ai.assistants.v1.searchindex.ChunkingStrategyR\x10chunkingStrategy\"\xbf\x04\n" +
	"\x11HybridSearchIndex\x12f\n" +
	"\x11text_search_index\x18\x01 \x01(\v2:.yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndexR\x0ftextSearchIndex\x12l\n" +
	"\x13vector_search_index\x18\x02 \x01(\v2<.yandex.cloud.ai.assistants.v1.searchindex.VectorSearchIndexR\x11vectorSearchIndex\x12h\n" +
	"\x11chunking_strategy\x18\x03 \x01(\v2;.yandex.cloud.ai.assistants.v1.searchindex.ChunkingStrategyR\x10chunkingStrategy\x12w\n" +
	"\x16normalization_strategy\x18\x04 \x01(\x0e2@.yandex.cloud.ai.assistants.v1.searchindex.NormalizationStrategyR\x15normalizationStrategy\x12q\n" +
	"\x14combination_strategy\x18\x05 \x01(\v2>.yandex.cloud.ai.assistants.v1.searchindex.CombinationStrategyR\x13combinationStrategyB\x8a\x01\n" +
	"-yandex.cloud.api.ai.assistants.v1.searchindexZYgithub.com/yandex-cloud/go-genproto/yandex/cloud/ai/assistants/v1/searchindex;searchindexb\x06proto3"

var (
	file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescOnce sync.Once
	file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescData []byte
)

func file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescGZIP() []byte {
	file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDesc), len(file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDesc)))
	})
	return file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDescData
}

var file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_goTypes = []any{
	(*SearchIndex)(nil),             // 0: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex
	(*TextSearchIndex)(nil),         // 1: yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndex
	(*VectorSearchIndex)(nil),       // 2: yandex.cloud.ai.assistants.v1.searchindex.VectorSearchIndex
	(*HybridSearchIndex)(nil),       // 3: yandex.cloud.ai.assistants.v1.searchindex.HybridSearchIndex
	nil,                             // 4: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.LabelsEntry
	(*timestamppb.Timestamp)(nil),   // 5: google.protobuf.Timestamp
	(*common.ExpirationConfig)(nil), // 6: yandex.cloud.ai.common.ExpirationConfig
	(*ChunkingStrategy)(nil),        // 7: yandex.cloud.ai.assistants.v1.searchindex.ChunkingStrategy
	(*NgramTokenizer)(nil),          // 8: yandex.cloud.ai.assistants.v1.searchindex.NgramTokenizer
	(*StandardTokenizer)(nil),       // 9: yandex.cloud.ai.assistants.v1.searchindex.StandardTokenizer
	(*StandardAnalyzer)(nil),        // 10: yandex.cloud.ai.assistants.v1.searchindex.StandardAnalyzer
	(*YandexLemmerAnalyzer)(nil),    // 11: yandex.cloud.ai.assistants.v1.searchindex.YandexLemmerAnalyzer
	(NormalizationStrategy)(0),      // 12: yandex.cloud.ai.assistants.v1.searchindex.NormalizationStrategy
	(*CombinationStrategy)(nil),     // 13: yandex.cloud.ai.assistants.v1.searchindex.CombinationStrategy
}
var file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_depIdxs = []int32{
	5,  // 0: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.created_at:type_name -> google.protobuf.Timestamp
	5,  // 1: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.updated_at:type_name -> google.protobuf.Timestamp
	6,  // 2: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.expiration_config:type_name -> yandex.cloud.ai.common.ExpirationConfig
	5,  // 3: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.expires_at:type_name -> google.protobuf.Timestamp
	4,  // 4: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.labels:type_name -> yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.LabelsEntry
	1,  // 5: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.text_search_index:type_name -> yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndex
	2,  // 6: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.vector_search_index:type_name -> yandex.cloud.ai.assistants.v1.searchindex.VectorSearchIndex
	3,  // 7: yandex.cloud.ai.assistants.v1.searchindex.SearchIndex.hybrid_search_index:type_name -> yandex.cloud.ai.assistants.v1.searchindex.HybridSearchIndex
	7,  // 8: yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndex.chunking_strategy:type_name -> yandex.cloud.ai.assistants.v1.searchindex.ChunkingStrategy
	8,  // 9: yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndex.ngram_tokenizer:type_name -> yandex.cloud.ai.assistants.v1.searchindex.NgramTokenizer
	9,  // 10: yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndex.standard_tokenizer:type_name -> yandex.cloud.ai.assistants.v1.searchindex.StandardTokenizer
	10, // 11: yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndex.standard_analyzer:type_name -> yandex.cloud.ai.assistants.v1.searchindex.StandardAnalyzer
	11, // 12: yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndex.yandex_lemmer_analyzer:type_name -> yandex.cloud.ai.assistants.v1.searchindex.YandexLemmerAnalyzer
	7,  // 13: yandex.cloud.ai.assistants.v1.searchindex.VectorSearchIndex.chunking_strategy:type_name -> yandex.cloud.ai.assistants.v1.searchindex.ChunkingStrategy
	1,  // 14: yandex.cloud.ai.assistants.v1.searchindex.HybridSearchIndex.text_search_index:type_name -> yandex.cloud.ai.assistants.v1.searchindex.TextSearchIndex
	2,  // 15: yandex.cloud.ai.assistants.v1.searchindex.HybridSearchIndex.vector_search_index:type_name -> yandex.cloud.ai.assistants.v1.searchindex.VectorSearchIndex
	7,  // 16: yandex.cloud.ai.assistants.v1.searchindex.HybridSearchIndex.chunking_strategy:type_name -> yandex.cloud.ai.assistants.v1.searchindex.ChunkingStrategy
	12, // 17: yandex.cloud.ai.assistants.v1.searchindex.HybridSearchIndex.normalization_strategy:type_name -> yandex.cloud.ai.assistants.v1.searchindex.NormalizationStrategy
	13, // 18: yandex.cloud.ai.assistants.v1.searchindex.HybridSearchIndex.combination_strategy:type_name -> yandex.cloud.ai.assistants.v1.searchindex.CombinationStrategy
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_init() }
func file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_init() {
	if File_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto != nil {
		return
	}
	file_yandex_cloud_ai_assistants_v1_searchindex_common_proto_init()
	file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[0].OneofWrappers = []any{
		(*SearchIndex_TextSearchIndex)(nil),
		(*SearchIndex_VectorSearchIndex)(nil),
		(*SearchIndex_HybridSearchIndex)(nil),
	}
	file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes[1].OneofWrappers = []any{
		(*TextSearchIndex_NgramTokenizer)(nil),
		(*TextSearchIndex_StandardTokenizer)(nil),
		(*TextSearchIndex_StandardAnalyzer)(nil),
		(*TextSearchIndex_YandexLemmerAnalyzer)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDesc), len(file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_msgTypes,
	}.Build()
	File_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto = out.File
	file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_goTypes = nil
	file_yandex_cloud_ai_assistants_v1_searchindex_search_index_proto_depIdxs = nil
}
