// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/billing/v1/budget_service.proto

package billing

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	BudgetService_Get_FullMethodName    = "/yandex.cloud.billing.v1.BudgetService/Get"
	BudgetService_List_FullMethodName   = "/yandex.cloud.billing.v1.BudgetService/List"
	BudgetService_Create_FullMethodName = "/yandex.cloud.billing.v1.BudgetService/Create"
)

// BudgetServiceClient is the client API for BudgetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing Budget resources.
type BudgetServiceClient interface {
	// Returns the specified budget.
	Get(ctx context.Context, in *GetBudgetRequest, opts ...grpc.CallOption) (*Budget, error)
	// Retrieves the list of budgets corresponding to the specified billing account.
	List(ctx context.Context, in *ListBudgetsRequest, opts ...grpc.CallOption) (*ListBudgetsResponse, error)
	// Creates a budget for the specified billing account.
	Create(ctx context.Context, in *CreateBudgetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type budgetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBudgetServiceClient(cc grpc.ClientConnInterface) BudgetServiceClient {
	return &budgetServiceClient{cc}
}

func (c *budgetServiceClient) Get(ctx context.Context, in *GetBudgetRequest, opts ...grpc.CallOption) (*Budget, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Budget)
	err := c.cc.Invoke(ctx, BudgetService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *budgetServiceClient) List(ctx context.Context, in *ListBudgetsRequest, opts ...grpc.CallOption) (*ListBudgetsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListBudgetsResponse)
	err := c.cc.Invoke(ctx, BudgetService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *budgetServiceClient) Create(ctx context.Context, in *CreateBudgetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BudgetService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BudgetServiceServer is the server API for BudgetService service.
// All implementations should embed UnimplementedBudgetServiceServer
// for forward compatibility.
//
// A set of methods for managing Budget resources.
type BudgetServiceServer interface {
	// Returns the specified budget.
	Get(context.Context, *GetBudgetRequest) (*Budget, error)
	// Retrieves the list of budgets corresponding to the specified billing account.
	List(context.Context, *ListBudgetsRequest) (*ListBudgetsResponse, error)
	// Creates a budget for the specified billing account.
	Create(context.Context, *CreateBudgetRequest) (*operation.Operation, error)
}

// UnimplementedBudgetServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedBudgetServiceServer struct{}

func (UnimplementedBudgetServiceServer) Get(context.Context, *GetBudgetRequest) (*Budget, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedBudgetServiceServer) List(context.Context, *ListBudgetsRequest) (*ListBudgetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedBudgetServiceServer) Create(context.Context, *CreateBudgetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedBudgetServiceServer) testEmbeddedByValue() {}

// UnsafeBudgetServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BudgetServiceServer will
// result in compilation errors.
type UnsafeBudgetServiceServer interface {
	mustEmbedUnimplementedBudgetServiceServer()
}

func RegisterBudgetServiceServer(s grpc.ServiceRegistrar, srv BudgetServiceServer) {
	// If the following call pancis, it indicates UnimplementedBudgetServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&BudgetService_ServiceDesc, srv)
}

func _BudgetService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBudgetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BudgetServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BudgetService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BudgetServiceServer).Get(ctx, req.(*GetBudgetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BudgetService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBudgetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BudgetServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BudgetService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BudgetServiceServer).List(ctx, req.(*ListBudgetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BudgetService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBudgetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BudgetServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BudgetService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BudgetServiceServer).Create(ctx, req.(*CreateBudgetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BudgetService_ServiceDesc is the grpc.ServiceDesc for BudgetService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BudgetService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.billing.v1.BudgetService",
	HandlerType: (*BudgetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _BudgetService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _BudgetService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _BudgetService_Create_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/billing/v1/budget_service.proto",
}
