// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Given a user pool app client ID, updates the configuration. To avoid setting
// parameters to Amazon Cognito defaults, construct this API request to pass the
// existing configuration of your app client, modified to include the changes that
// you want to make.
//
// If you don't provide a value for an attribute, Amazon Cognito sets it to its
// default value.
//
// Unlike app clients created in the console, Amazon Cognito doesn't automatically
// assign a branding style to app clients that you configure with this API
// operation. Managed login and classic hosted UI pages aren't available for your
// client until after you apply a branding style.
//
// Amazon Cognito evaluates Identity and Access Management (IAM) policies in
// requests for this API operation. For this operation, you must use IAM
// credentials to authorize requests, and you must grant yourself the corresponding
// IAM permission in a policy.
//
// # Learn more
//
// [Signing Amazon Web Services API Requests]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [Signing Amazon Web Services API Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html
func (c *Client) UpdateUserPoolClient(ctx context.Context, params *UpdateUserPoolClientInput, optFns ...func(*Options)) (*UpdateUserPoolClientOutput, error) {
	if params == nil {
		params = &UpdateUserPoolClientInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateUserPoolClient", params, optFns, c.addOperationUpdateUserPoolClientMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateUserPoolClientOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the request to update the user pool client.
type UpdateUserPoolClientInput struct {

	// The ID of the app client that you want to update.
	//
	// This member is required.
	ClientId *string

	// The ID of the user pool where you want to update the app client.
	//
	// This member is required.
	UserPoolId *string

	// The access token time limit. After this limit expires, your user can't use
	// their access token. To specify the time unit for AccessTokenValidity as seconds
	// , minutes , hours , or days , set a TokenValidityUnits value in your API
	// request.
	//
	// For example, when you set AccessTokenValidity to 10 and TokenValidityUnits to
	// hours , your user can authorize access with their access token for 10 hours.
	//
	// The default time unit for AccessTokenValidity in an API request is hours. Valid
	// range is displayed below in seconds.
	//
	// If you don't specify otherwise in the configuration of your app client, your
	// access tokens are valid for one hour.
	AccessTokenValidity *int32

	// The OAuth grant types that you want your app client to generate. To create an
	// app client that generates client credentials grants, you must add
	// client_credentials as the only allowed OAuth flow.
	//
	// code Use a code grant flow, which provides an authorization code as the
	// response. This code can be exchanged for access tokens with the /oauth2/token
	// endpoint.
	//
	// implicit Issue the access token (and, optionally, ID token, based on scopes)
	// directly to your user.
	//
	// client_credentials Issue the access token from the /oauth2/token endpoint
	// directly to a non-person user using a combination of the client ID and client
	// secret.
	AllowedOAuthFlows []types.OAuthFlowType

	// Set to true to use OAuth 2.0 authorization server features in your app client.
	//
	// This parameter must have a value of true before you can configure the following
	// features in your app client.
	//
	//   - CallBackURLs : Callback URLs.
	//
	//   - LogoutURLs : Sign-out redirect URLs.
	//
	//   - AllowedOAuthScopes : OAuth 2.0 scopes.
	//
	//   - AllowedOAuthFlows : Support for authorization code, implicit, and client
	//   credentials OAuth 2.0 grants.
	//
	// To use authorization server features, configure one of these features in the
	// Amazon Cognito console or set AllowedOAuthFlowsUserPoolClient to true in a
	// CreateUserPoolClient or UpdateUserPoolClient API request. If you don't set a
	// value for AllowedOAuthFlowsUserPoolClient in a request with the CLI or SDKs, it
	// defaults to false . When false , only SDK-based API sign-in is permitted.
	AllowedOAuthFlowsUserPoolClient bool

	// The OAuth, OpenID Connect (OIDC), and custom scopes that you want to permit
	// your app client to authorize access with. Scopes govern access control to user
	// pool self-service API operations, user data from the userInfo endpoint, and
	// third-party APIs. Scope values include phone , email , openid , and profile .
	// The aws.cognito.signin.user.admin scope authorizes user self-service
	// operations. Custom scopes with resource servers authorize access to external
	// APIs.
	AllowedOAuthScopes []string

	// The user pool analytics configuration for collecting metrics and sending them
	// to your Amazon Pinpoint campaign.
	//
	// In Amazon Web Services Regions where Amazon Pinpoint isn't available, user
	// pools might not have access to analytics or might be configurable with campaigns
	// in the US East (N. Virginia) Region. For more information, see [Using Amazon Pinpoint analytics].
	//
	// [Using Amazon Pinpoint analytics]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html
	AnalyticsConfiguration *types.AnalyticsConfigurationType

	// Amazon Cognito creates a session token for each API request in an
	// authentication flow. AuthSessionValidity is the duration, in minutes, of that
	// session token. Your user pool native user must respond to each authentication
	// challenge before the session expires.
	AuthSessionValidity *int32

	// A list of allowed redirect, or callback, URLs for managed login authentication.
	// These URLs are the paths where you want to send your users' browsers after they
	// complete authentication with managed login or a third-party IdP. Typically,
	// callback URLs are the home of an application that uses OAuth or OIDC libraries
	// to process authentication outcomes.
	//
	// A redirect URI must meet the following requirements:
	//
	//   - Be an absolute URI.
	//
	//   - Be registered with the authorization server. Amazon Cognito doesn't accept
	//   authorization requests with redirect_uri values that aren't in the list of
	//   CallbackURLs that you provide in this parameter.
	//
	//   - Not include a fragment component.
	//
	// See [OAuth 2.0 - Redirection Endpoint].
	//
	// Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing
	// purposes only.
	//
	// App callback URLs such as myapp://example are also supported.
	//
	// [OAuth 2.0 - Redirection Endpoint]: https://tools.ietf.org/html/rfc6749#section-3.1.2
	CallbackURLs []string

	// A friendly name for the app client.
	ClientName *string

	// The default redirect URI. In app clients with one assigned IdP, replaces
	// redirect_uri in authentication requests. Must be in the CallbackURLs list.
	DefaultRedirectURI *string

	// When true , your application can include additional UserContextData in
	// authentication requests. This data includes the IP address, and contributes to
	// analysis by threat protection features. For more information about propagation
	// of user context data, see [Adding session data to API requests]. If you don’t include this parameter, you can't send
	// the source IP address to Amazon Cognito threat protection features. You can only
	// activate EnablePropagateAdditionalUserContextData in an app client that has a
	// client secret.
	//
	// [Adding session data to API requests]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint
	EnablePropagateAdditionalUserContextData *bool

	// Activates or deactivates [token revocation] in the target app client.
	//
	// [token revocation]: https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html
	EnableTokenRevocation *bool

	// The [authentication flows] that you want your user pool client to support. For each app client in
	// your user pool, you can sign in your users with any combination of one or more
	// flows, including with a user name and Secure Remote Password (SRP), a user name
	// and password, or a custom authentication process that you define with Lambda
	// functions.
	//
	// If you don't specify a value for ExplicitAuthFlows , your app client supports
	// ALLOW_REFRESH_TOKEN_AUTH , ALLOW_USER_SRP_AUTH , and ALLOW_CUSTOM_AUTH .
	//
	// The values for authentication flow options include the following.
	//
	//   - ALLOW_USER_AUTH : Enable selection-based sign-in with USER_AUTH . This
	//   setting covers username-password, secure remote password (SRP), passwordless,
	//   and passkey authentication. This authentiation flow can do username-password and
	//   SRP authentication without other ExplicitAuthFlows permitting them. For
	//   example users can complete an SRP challenge through USER_AUTH without the flow
	//   USER_SRP_AUTH being active for the app client. This flow doesn't include
	//   CUSTOM_AUTH .
	//
	// To activate this setting, your user pool must be in the [Essentials tier]or higher.
	//
	//   - ALLOW_ADMIN_USER_PASSWORD_AUTH : Enable admin based user password
	//   authentication flow ADMIN_USER_PASSWORD_AUTH . This setting replaces the
	//   ADMIN_NO_SRP_AUTH setting. With this authentication flow, your app passes a
	//   user name and password to Amazon Cognito in the request, instead of using the
	//   Secure Remote Password (SRP) protocol to securely transmit the password.
	//
	//   - ALLOW_CUSTOM_AUTH : Enable Lambda trigger based authentication.
	//
	//   - ALLOW_USER_PASSWORD_AUTH : Enable user password-based authentication. In
	//   this flow, Amazon Cognito receives the password in the request instead of using
	//   the SRP protocol to verify passwords.
	//
	//   - ALLOW_USER_SRP_AUTH : Enable SRP-based authentication.
	//
	//   - ALLOW_REFRESH_TOKEN_AUTH : Enable authflow to refresh tokens.
	//
	// In some environments, you will see the values ADMIN_NO_SRP_AUTH ,
	// CUSTOM_AUTH_FLOW_ONLY , or USER_PASSWORD_AUTH . You can't assign these legacy
	// ExplicitAuthFlows values to user pool clients at the same time as values that
	// begin with ALLOW_ , like ALLOW_USER_SRP_AUTH .
	//
	// [authentication flows]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html
	// [Essentials tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html
	ExplicitAuthFlows []types.ExplicitAuthFlowsType

	// The ID token time limit. After this limit expires, your user can't use their ID
	// token. To specify the time unit for IdTokenValidity as seconds , minutes , hours
	// , or days , set a TokenValidityUnits value in your API request.
	//
	// For example, when you set IdTokenValidity as 10 and TokenValidityUnits as hours
	// , your user can authenticate their session with their ID token for 10 hours.
	//
	// The default time unit for IdTokenValidity in an API request is hours. Valid
	// range is displayed below in seconds.
	//
	// If you don't specify otherwise in the configuration of your app client, your ID
	// tokens are valid for one hour.
	IdTokenValidity *int32

	// A list of allowed logout URLs for managed login authentication. When you pass
	// logout_uri and client_id parameters to /logout , Amazon Cognito signs out your
	// user and redirects them to the logout URL. This parameter describes the URLs
	// that you want to be the permitted targets of logout_uri . A typical use of these
	// URLs is when a user selects "Sign out" and you redirect them to your public
	// homepage. For more information, see [Logout endpoint].
	//
	// [Logout endpoint]: https://docs.aws.amazon.com/cognito/latest/developerguide/logout-endpoint.html
	LogoutURLs []string

	// When ENABLED , suppresses messages that might indicate a valid user exists when
	// someone attempts sign-in. This parameters sets your preference for the errors
	// and responses that you want Amazon Cognito APIs to return during authentication,
	// account confirmation, and password recovery when the user doesn't exist in the
	// user pool. When set to ENABLED and the user doesn't exist, authentication
	// returns an error indicating either the username or password was incorrect.
	// Account confirmation and password recovery return a response indicating a code
	// was sent to a simulated destination. When set to LEGACY , those APIs return a
	// UserNotFoundException exception if the user doesn't exist in the user pool.
	//
	// Defaults to LEGACY .
	PreventUserExistenceErrors types.PreventUserExistenceErrorTypes

	// The list of user attributes that you want your app client to have read access
	// to. After your user authenticates in your app, their access token authorizes
	// them to read their own attribute value for any attribute in this list.
	//
	// When you don't specify the ReadAttributes for your app client, your app can
	// read the values of email_verified , phone_number_verified , and the standard
	// attributes of your user pool. When your user pool app client has read access to
	// these default attributes, ReadAttributes doesn't return any information. Amazon
	// Cognito only populates ReadAttributes in the API response if you have specified
	// your own custom set of read attributes.
	ReadAttributes []string

	// The refresh token time limit. After this limit expires, your user can't use
	// their refresh token. To specify the time unit for RefreshTokenValidity as
	// seconds , minutes , hours , or days , set a TokenValidityUnits value in your
	// API request.
	//
	// For example, when you set RefreshTokenValidity as 10 and TokenValidityUnits as
	// days , your user can refresh their session and retrieve new access and ID tokens
	// for 10 days.
	//
	// The default time unit for RefreshTokenValidity in an API request is days. You
	// can't set RefreshTokenValidity to 0. If you do, Amazon Cognito overrides the
	// value with the default value of 30 days. Valid range is displayed below in
	// seconds.
	//
	// If you don't specify otherwise in the configuration of your app client, your
	// refresh tokens are valid for 30 days.
	RefreshTokenValidity int32

	// A list of provider names for the identity providers (IdPs) that are supported
	// on this client. The following are supported: COGNITO , Facebook , Google ,
	// SignInWithApple , and LoginWithAmazon . You can also specify the names that you
	// configured for the SAML and OIDC IdPs in your user pool, for example MySAMLIdP
	// or MyOIDCIdP .
	//
	// This parameter sets the IdPs that [managed login] will display on the login page for your app
	// client. The removal of COGNITO from this list doesn't prevent authentication
	// operations for local users with the user pools API in an Amazon Web Services
	// SDK. The only way to prevent SDK-based authentication is to block access with a [WAF rule]
	// .
	//
	// [WAF rule]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html
	// [managed login]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html
	SupportedIdentityProviders []string

	// The units that validity times are represented in. The default unit for refresh
	// tokens is days, and the default for ID and access tokens are hours.
	TokenValidityUnits *types.TokenValidityUnitsType

	// The list of user attributes that you want your app client to have write access
	// to. After your user authenticates in your app, their access token authorizes
	// them to set or modify their own attribute value for any attribute in this list.
	//
	// When you don't specify the WriteAttributes for your app client, your app can
	// write the values of the Standard attributes of your user pool. When your user
	// pool has write access to these default attributes, WriteAttributes doesn't
	// return any information. Amazon Cognito only populates WriteAttributes in the
	// API response if you have specified your own custom set of write attributes.
	//
	// If your app client allows users to sign in through an IdP, this array must
	// include all attributes that you have mapped to IdP attributes. Amazon Cognito
	// updates mapped attributes when users sign in to your application through an IdP.
	// If your app client does not have write access to a mapped attribute, Amazon
	// Cognito throws an error when it tries to update the attribute. For more
	// information, see [Specifying IdP Attribute Mappings for Your user pool].
	//
	// [Specifying IdP Attribute Mappings for Your user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html
	WriteAttributes []string

	noSmithyDocumentSerde
}

// Represents the response from the server to the request to update the user pool
// client.
type UpdateUserPoolClientOutput struct {

	// The updated details of your app client.
	UserPoolClient *types.UserPoolClientType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateUserPoolClientMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateUserPoolClient{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateUserPoolClient{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateUserPoolClient"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateUserPoolClientValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateUserPoolClient(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateUserPoolClient(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateUserPoolClient",
	}
}
