/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateVolumeBackupPolicyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateVolumeBackupPolicyRequest
extends BmcRequest<UpdateVolumeBackupPolicyDetails> {
    private String policyId;
    private UpdateVolumeBackupPolicyDetails updateVolumeBackupPolicyDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getPolicyId() {
        return this.policyId;
    }

    public UpdateVolumeBackupPolicyDetails getUpdateVolumeBackupPolicyDetails() {
        return this.updateVolumeBackupPolicyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public UpdateVolumeBackupPolicyDetails getBody$() {
        return this.updateVolumeBackupPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().policyId(this.policyId).updateVolumeBackupPolicyDetails(this.updateVolumeBackupPolicyDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",policyId=").append(String.valueOf(this.policyId));
        sb.append(",updateVolumeBackupPolicyDetails=").append(String.valueOf((Object)this.updateVolumeBackupPolicyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVolumeBackupPolicyRequest)) {
            return false;
        }
        UpdateVolumeBackupPolicyRequest other = (UpdateVolumeBackupPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.policyId, other.policyId) && Objects.equals((Object)this.updateVolumeBackupPolicyDetails, (Object)other.updateVolumeBackupPolicyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.policyId == null ? 43 : this.policyId.hashCode());
        result = result * 59 + (this.updateVolumeBackupPolicyDetails == null ? 43 : this.updateVolumeBackupPolicyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateVolumeBackupPolicyRequest, UpdateVolumeBackupPolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String policyId = null;
        private UpdateVolumeBackupPolicyDetails updateVolumeBackupPolicyDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public Builder updateVolumeBackupPolicyDetails(UpdateVolumeBackupPolicyDetails updateVolumeBackupPolicyDetails) {
            this.updateVolumeBackupPolicyDetails = updateVolumeBackupPolicyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVolumeBackupPolicyRequest o) {
            this.policyId(o.getPolicyId());
            this.updateVolumeBackupPolicyDetails(o.getUpdateVolumeBackupPolicyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVolumeBackupPolicyRequest build() {
            UpdateVolumeBackupPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateVolumeBackupPolicyDetails body) {
            this.updateVolumeBackupPolicyDetails(body);
            return this;
        }

        public UpdateVolumeBackupPolicyRequest buildWithoutInvocationCallback() {
            UpdateVolumeBackupPolicyRequest request = new UpdateVolumeBackupPolicyRequest();
            request.policyId = this.policyId;
            request.updateVolumeBackupPolicyDetails = this.updateVolumeBackupPolicyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

