/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.editor.semantic.SequenceElement;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class GsfSemanticLayer
extends AbstractHighlightsContainer {
    private List<SequenceElement> colorings = List.of();
    private final Map<Language, Map<ColoringAttributes.Coloring, AttributeSet>> cache = new HashMap<Language, Map<ColoringAttributes.Coloring, AttributeSet>>();
    private final Document doc;
    private final List<Lookup.Result> coloringResults = new ArrayList<Lookup.Result>(3);
    private final List<LookupListener> coloringListeners = new ArrayList<LookupListener>(3);

    public static GsfSemanticLayer getLayer(Class id, Document doc) {
        GsfSemanticLayer l = (GsfSemanticLayer)((Object)doc.getProperty(id));
        if (l == null) {
            l = new GsfSemanticLayer(doc);
            doc.putProperty(id, (Object)l);
        }
        return l;
    }

    private GsfSemanticLayer(Document doc) {
        this.doc = doc;
    }

    void setColorings(SortedSet<SequenceElement> colorings) {
        this.doc.render(() -> {
            GsfSemanticLayer gsfSemanticLayer = this;
            synchronized (gsfSemanticLayer) {
                this.colorings = List.copyOf(colorings);
                this.fireHighlightsChange(0, this.doc.getLength());
            }
        });
    }

    public synchronized HighlightsSequence getHighlights(int startOffset, int endOffset) {
        if (this.colorings.isEmpty()) {
            return HighlightsSequence.EMPTY;
        }
        int seqStart = GsfSemanticLayer.firstSequenceElement(this.colorings, startOffset);
        return new GsfHighlightSequence(this.colorings.listIterator(seqStart));
    }

    public synchronized void clearColoringCache() {
        this.cache.clear();
    }

    private synchronized void clearLanguageColoring(Language mime) {
        this.cache.remove(mime);
    }

    synchronized AttributeSet getColoring(ColoringAttributes.Coloring coloring, Language language) {
        Map langColoring = this.cache.computeIfAbsent(language, lang -> {
            this.registerColoringChangeListener((Language)lang);
            return new HashMap();
        });
        return langColoring.computeIfAbsent(coloring, c -> language.getColoringManager().getColoringImpl((ColoringAttributes.Coloring)c));
    }

    private void registerColoringChangeListener(Language language) {
        String mime = language.getMimeType();
        Lookup.Result res = MimeLookup.getLookup((MimePath)MimePath.get((String)mime)).lookupResult(FontColorSettings.class);
        this.coloringResults.add(res);
        LookupListener l = ev -> {
            this.clearLanguageColoring(language);
            this.fireHighlightsChange(0, this.doc.getLength());
        };
        res.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)l, (Object)res));
        this.coloringListeners.add(l);
    }

    static int firstSequenceElement(List<SequenceElement> l, int offset) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            SequenceElement midVal = l.get(mid);
            int cmp = midVal.start().getOffset() - offset;
            if (cmp == 0) {
                return mid;
            }
            if (low == high) {
                if (mid > 0 && cmp >= 0) {
                    return mid - 1;
                }
                return low;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
        return low;
    }

    private final class GsfHighlightSequence
    implements HighlightsSequence {
        private final Iterator<SequenceElement> iterator;
        private SequenceElement element;

        GsfHighlightSequence(Iterator<SequenceElement> it) {
            this.iterator = it;
        }

        public boolean moveNext() {
            while (this.iterator.hasNext()) {
                SequenceElement i = this.iterator.next();
                if (i.start().getOffset() == i.end().getOffset()) continue;
                this.element = i;
                return true;
            }
            this.element = null;
            return false;
        }

        public int getStartOffset() {
            return this.element.start().getOffset();
        }

        public int getEndOffset() {
            return this.element.end().getOffset();
        }

        public AttributeSet getAttributes() {
            return GsfSemanticLayer.this.getColoring(this.element.coloring(), this.element.language());
        }
    }
}

