/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LegendFont;
import org.netbeans.modules.profiler.snaptracer.impl.swing.Spacer;

final class TimelineTooltipPainter
extends JPanel {
    private static Color SELECTION_FOREGROUND = Color.BLACK;
    private static Color SELECTION_BACKGROUND = Utils.forceSpeed() ? new Color(255, 255, 255) : new Color(255, 255, 255, 225);
    private static Color HOVER_FOREGROUND = Color.WHITE;
    private static Color HOVER_BACKGROUND = Utils.forceSpeed() ? new Color(80, 80, 80) : new Color(0, 0, 0, 170);
    private JLabel[] valueNames;
    private JLabel[] valuePainters;
    private JLabel[] unitsPainters;
    private final boolean selection;
    private final Color foreground;
    private final Color background;

    TimelineTooltipPainter(boolean selection) {
        this.selection = selection;
        this.foreground = selection ? SELECTION_FOREGROUND : HOVER_FOREGROUND;
        this.background = selection ? SELECTION_BACKGROUND : HOVER_BACKGROUND;
        this.initUI();
    }

    void update(Model rowModel, List<ItemSelection> selectedItems) {
        int rowsCount = rowModel.getRowsCount();
        if (this.valueNames == null || this.valueNames.length != rowsCount) {
            this.initComponents(rowsCount);
        }
        for (int i = 0; i < rowsCount; ++i) {
            XYItemSelection sel = (XYItemSelection)selectedItems.get(i);
            long itemValue = sel.getItem().getYValue(sel.getValueIndex());
            this.valueNames[i].setText(rowModel.getRowName(i));
            this.valuePainters[i].setText(rowModel.getRowValue(i, itemValue));
            this.unitsPainters[i].setText(rowModel.getRowUnits(i));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.background);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
        if (this.selection) {
            g.setColor(this.foreground);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    private void initUI() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
    }

    private void initComponents(int rowsCount) {
        this.removeAll();
        this.valueNames = new JLabel[rowsCount];
        this.valuePainters = new JLabel[rowsCount];
        this.unitsPainters = new JLabel[rowsCount];
        int i = 0;
        while (i < rowsCount) {
            JLabel unitsLabel;
            JLabel valueLabel;
            JLabel itemLabel;
            this.valueNames[i] = itemLabel = new JLabel();
            itemLabel.setFont(new LegendFont());
            itemLabel.setForeground(this.foreground);
            itemLabel.setOpaque(false);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = i;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)itemLabel, constraints);
            this.valuePainters[i] = valueLabel = new JLabel();
            valueLabel.setFont(new LegendFont());
            valueLabel.setForeground(this.foreground);
            valueLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = i;
            constraints.gridwidth = 1;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)valueLabel, constraints);
            this.unitsPainters[i] = unitsLabel = new JLabel();
            unitsLabel.setFont(new LegendFont());
            unitsLabel.setForeground(this.foreground);
            unitsLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = i;
            constraints.gridwidth = 1;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 3, 0, 0);
            this.add((Component)unitsLabel, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = i++;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.anchor = 12;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)Spacer.create(), constraints);
        }
    }

    static interface Model {
        public int getRowsCount();

        public String getRowName(int var1);

        public String getRowValue(int var1, long var2);

        public String getRowUnits(int var1);
    }
}

