/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileUtil;

public class OpenGradleProjectForBinary
implements SourceForBinaryQueryImplementation2 {
    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        if ("jar".equals(binaryRoot.getProtocol())) {
            try {
                URI uri = FileUtil.getArchiveFile((URL)binaryRoot).toURI();
                if ("file".equals(uri.getScheme())) {
                    File jar = new File(uri);
                    Map<String, Project> projectArchives = this.projectArchives();
                    Project p = projectArchives.get(jar.getName());
                    if (p != null) {
                        GradleJavaProject gjp = GradleJavaProject.get(p);
                        File archive = gjp.getArchive("");
                        URL root = FileUtil.urlForArchiveOrDir((File)archive);
                        SourceForBinaryQueryImplementation2 query = (SourceForBinaryQueryImplementation2)p.getLookup().lookup(SourceForBinaryQueryImplementation2.class);
                        return query != null ? query.findSourceRoots2(root) : null;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    Map<String, Project> projectArchives() {
        Project[] projects;
        HashMap<String, Project> ret = new HashMap<String, Project>();
        for (Project project : projects = OpenProjects.getDefault().getOpenProjects()) {
            File archive;
            GradleJavaProject gjp = GradleJavaProject.get(project);
            if (gjp == null || (archive = gjp.getArchive("")) == null) continue;
            ret.put(archive.getName(), project);
        }
        return ret;
    }
}

