/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.eecommon.api.HttpMonitorHelper;
import org.netbeans.modules.glassfish.javaee.Hk2Configuration;
import org.netbeans.modules.glassfish.javaee.ModuleConfigurationImpl;
import org.netbeans.modules.glassfish.javaee.ResourceRegistrationHelper;
import org.netbeans.modules.glassfish.javaee.ide.DummyProgressObject;
import org.netbeans.modules.glassfish.javaee.ide.Hk2PluginProperties;
import org.netbeans.modules.glassfish.javaee.ide.Hk2Target;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.javaee.ide.MonitorProgressObject;
import org.netbeans.modules.glassfish.javaee.ide.UpdateContextRoot;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule2;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.glassfish.tooling.TaskStateListener;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentManager2;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class Hk2DeploymentManager
implements DeploymentManager2 {
    private volatile ServerInstance serverInstance;
    private final InstanceProperties instanceProperties;
    private final Hk2PluginProperties pluginProperties;
    private final String uri;
    private final ServerUtilities su;

    public Hk2DeploymentManager(String uri, String uname, String passwd, ServerUtilities su) {
        this.uri = uri;
        this.su = su;
        this.pluginProperties = new Hk2PluginProperties(this, su);
        this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.getUri());
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan) throws IllegalStateException {
        return this.distribute(targetList, moduleArchive, deploymentPlan, new File[0], null);
    }

    public ProgressObject distribute(Target[] targets, DeploymentContext context) {
        ModuleConfigurationImpl mci;
        String cr = null;
        String moduleFilePath = context.getModuleFile().getAbsolutePath();
        if (moduleFilePath.endsWith(".war") && null != (mci = ModuleConfigurationImpl.get(context.getModule()))) {
            try {
                cr = mci.getContextRoot();
            }
            catch (ConfigurationException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, "could not getContextRoot() for {0}", moduleFilePath);
            }
        }
        return this.distribute(targets, context.getModuleFile(), context.getDeploymentPlan(), context.getRequiredLibraries(), cr);
    }

    private ProgressObject distribute(Target[] targetList, final File moduleArchive, File deploymentPlan, File[] requiredLibraries, String cr) throws IllegalStateException {
        String t = moduleArchive.getName();
        final GlassfishModule commonSupport = this.getCommonServerSupport();
        String url = (String)commonSupport.getInstanceProperties().get("url");
        String targ = Hk2DeploymentManager.getTargetFromUri(url);
        Object nameSuffix = "";
        if (null != targ) {
            nameSuffix = "_" + targ;
        }
        final String moduleName = Utils.sanitizeName((String)t.substring(0, t.length() - 4)) + (String)nameSuffix;
        Hk2TargetModuleID moduleId = Hk2TargetModuleID.get((Hk2Target)targetList[0], moduleName, null, moduleArchive.getAbsolutePath());
        final MonitorProgressObject deployProgress = new MonitorProgressObject(this, moduleId);
        MonitorProgressObject updateCRProgress = new MonitorProgressObject(this, moduleId);
        deployProgress.addProgressListener(new UpdateContextRoot(updateCRProgress, moduleId, this.getServerInstance(), true));
        MonitorProgressObject restartProgress = new MonitorProgressObject(this, moduleId);
        GlassfishModule2 commonSupport2 = commonSupport instanceof GlassfishModule2 ? (GlassfishModule2)commonSupport : null;
        boolean restart = false;
        try {
            restart = HttpMonitorHelper.synchronizeMonitor((String)((String)commonSupport.getInstanceProperties().get("domainsfolder")), (String)((String)commonSupport.getInstanceProperties().get("domainname")), (boolean)Boolean.parseBoolean((String)commonSupport.getInstanceProperties().get("httpMonitorOn")), (commonSupport.getInstance().getVersion().getMajor() > 5 ? 1 : 0) != 0, (String[])new String[]{"modules/org-netbeans-modules-schema2beans.jar"});
        }
        catch (IOException | SAXException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", ex);
        }
        ResourceRegistrationHelper.deployResources(moduleArchive, this);
        if (restart) {
            restartProgress.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    if (event.getDeploymentStatus().isCompleted()) {
                        commonSupport.deploy((TaskStateListener)deployProgress, moduleArchive, moduleName);
                    } else {
                        deployProgress.fireHandleProgressEvent(event.getDeploymentStatus());
                    }
                }
            });
            commonSupport.restartServer((TaskStateListener)restartProgress);
            return updateCRProgress;
        }
        if (commonSupport2 != null && requiredLibraries.length > 0) {
            commonSupport2.deploy((TaskStateListener)deployProgress, moduleArchive, moduleName, cr, Collections.emptyMap(), requiredLibraries);
        } else {
            commonSupport.deploy((TaskStateListener)deployProgress, moduleArchive, moduleName, cr);
        }
        return updateCRProgress;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        return this.redeploy(moduleIDList, moduleArchive, deploymentPlan, new File[0]);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, DeploymentContext context) {
        return this.redeploy(moduleIDList, context.getModuleFile(), context.getDeploymentPlan(), context.getRequiredLibraries());
    }

    private ProgressObject redeploy(TargetModuleID[] moduleIDList, final File moduleArchive, File deploymentPlan, File[] requiredLibraries) throws UnsupportedOperationException, IllegalStateException {
        Hk2TargetModuleID moduleId = (Hk2TargetModuleID)moduleIDList[0];
        final String moduleName = moduleId.getModuleID();
        final MonitorProgressObject progressObject = new MonitorProgressObject(this, moduleId, CommandType.REDEPLOY);
        MonitorProgressObject restartObject = new MonitorProgressObject(this, moduleId, CommandType.REDEPLOY);
        MonitorProgressObject updateCRObject = new MonitorProgressObject(this, moduleId, CommandType.REDEPLOY);
        final GlassfishModule commonSupport = this.getCommonServerSupport();
        GlassfishModule2 commonSupport2 = commonSupport instanceof GlassfishModule2 ? (GlassfishModule2)commonSupport : null;
        progressObject.addProgressListener(new UpdateContextRoot(updateCRObject, moduleId, this.getServerInstance(), true));
        boolean restart = false;
        try {
            restart = HttpMonitorHelper.synchronizeMonitor((String)((String)commonSupport.getInstanceProperties().get("domainsfolder")), (String)((String)commonSupport.getInstanceProperties().get("domainname")), (boolean)Boolean.parseBoolean((String)commonSupport.getInstanceProperties().get("httpMonitorOn")), (commonSupport.getInstance().getVersion().getMajor() > 5 ? 1 : 0) != 0, (String[])new String[]{"modules/org-netbeans-modules-schema2beans.jar"});
        }
        catch (IOException | SAXException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", ex);
        }
        ResourceRegistrationHelper.deployResources(moduleArchive, this);
        if (restart) {
            restartObject.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    if (event.getDeploymentStatus().isCompleted()) {
                        commonSupport.deploy((TaskStateListener)progressObject, moduleArchive, moduleName);
                    } else {
                        progressObject.fireHandleProgressEvent(event.getDeploymentStatus());
                    }
                }
            });
            commonSupport.restartServer((TaskStateListener)restartObject);
            return updateCRObject;
        }
        if (commonSupport2 != null && requiredLibraries.length > 0) {
            commonSupport2.deploy((TaskStateListener)progressObject, moduleArchive, moduleName, null, Collections.emptyMap(), requiredLibraries);
        } else {
            commonSupport.deploy((TaskStateListener)progressObject, moduleArchive, moduleName);
        }
        return updateCRObject;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        return new Hk2Configuration(deployableObject);
    }

    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        throw new UnsupportedOperationException("Hk2DeploymentManager.distribute(target [], stream, stream) not supported yet.");
    }

    public ProgressObject distribute(Target[] targetList, ModuleType type, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        throw new UnsupportedOperationException("Hk2DeploymentManager.distribute(target [], module_type, stream, stream) not supported yet.");
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("Hk2DeploymentManager.redeploy(target_module [], stream, stream) not supported yet.");
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        if (targetModuleIDs != null && targetModuleIDs.length > 0) {
            GlassfishModule commonSupport = this.getCommonServerSupport();
            MonitorProgressObject progressObject = new MonitorProgressObject(this, (Hk2TargetModuleID)targetModuleIDs[0], CommandType.UNDEPLOY);
            commonSupport.undeploy((TaskStateListener)progressObject, targetModuleIDs[0].getModuleID());
            return progressObject;
        }
        throw new IllegalArgumentException("No TargetModuleID's specified.");
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return new DummyProgressObject(moduleIDList[0]);
    }

    public ProgressObject start(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return new DummyProgressObject(moduleIDList[0]);
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
    }

    public boolean isLocaleSupported(Locale locale) {
        return false;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getDeployedModules(moduleType, targetList);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Hk2DeploymentManager.getNonRunningModules() not supported yet.");
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getDeployedModules(moduleType, targetList);
    }

    private TargetModuleID[] getDeployedModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        AppDesc[] appList;
        ArrayList<Hk2TargetModuleID> moduleList = new ArrayList<Hk2TargetModuleID>();
        GlassfishModule commonSupport = this.getCommonServerSupport();
        if (commonSupport != null && (appList = commonSupport.getModuleList("web")) != null && appList.length > 0) {
            if (targetList[0] instanceof Hk2Target) {
                Hk2Target target = (Hk2Target)targetList[0];
                for (AppDesc app : appList) {
                    moduleList.add(Hk2TargetModuleID.get(target, app.getName(), "".equals(app.getContextRoot()) ? null : app.getContextRoot(), app.getPath()));
                }
            } else {
                String targetDesc = targetList[0] != null ? targetList[0].toString() : "(null)";
                throw new TargetException(NbBundle.getMessage(Hk2DeploymentManager.class, (String)"ERR_WrongTarget", (Object)targetDesc));
            }
        }
        return moduleList.size() > 0 ? (TargetModuleID[])moduleList.toArray(TargetModuleID[]::new) : new TargetModuleID[]{};
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return false;
    }

    public void release() {
    }

    public boolean isRedeploySupported() {
        return this.isLocal();
    }

    public Locale getCurrentLocale() {
        return null;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return null;
    }

    public Locale getDefaultLocale() {
        return null;
    }

    public Locale[] getSupportedLocales() {
        return new Locale[]{Locale.getDefault()};
    }

    public Target[] getTargets() throws IllegalStateException {
        InstanceProperties ip = this.getInstanceProperties();
        if (null == ip) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, "instance props are null for URI: " + this.getUri(), new Exception());
            return new Hk2Target[0];
        }
        String url = ip.getProperty("url");
        String protocol = "http";
        String host = ip.getProperty("host");
        String httpPort = (String)this.getCommonServerSupport().getInstanceProperties().get("httpportnumber");
        if (url == null || !url.contains("ee6wc")) {
            protocol = Utils.getHttpListenerProtocol((String)host, (String)httpPort);
        }
        String serverUri = this.constructServerUri(protocol, host, httpPort, null);
        String name = ip.getProperty("displayName");
        Hk2Target target = new Hk2Target(name, serverUri);
        Target[] targets = new Hk2Target[]{target};
        return targets;
    }

    public final String getUri() {
        return this.uri;
    }

    public Hk2PluginProperties getProperties() {
        return this.pluginProperties;
    }

    public InstanceProperties getInstanceProperties() {
        return this.instanceProperties;
    }

    public ServerInstance getServerInstance() {
        if (this.serverInstance != null) {
            return this.serverInstance;
        }
        this.serverInstance = this.su.getServerInstance(this.uri);
        if (this.serverInstance == null) {
            String warning = "Common server instance not found for " + this.uri;
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, warning);
            throw new IllegalStateException(warning);
        }
        return this.serverInstance;
    }

    public GlassfishModule getCommonServerSupport() {
        GlassfishInstance instance = GlassfishInstanceProvider.getGlassFishInstanceByUri((String)this.uri);
        return instance != null ? instance.getCommonSupport() : null;
    }

    private String constructServerUri(String protocol, String host, String port, String path) {
        StringBuilder builder = new StringBuilder(128);
        builder.append(protocol);
        builder.append("://");
        builder.append(host);
        builder.append(":");
        builder.append(port);
        if (path != null && path.length() > 0) {
            builder.append(path);
        }
        return builder.toString();
    }

    public boolean isLocal() {
        boolean result = true;
        GlassfishModule commonSupport = this.getCommonServerSupport();
        if (commonSupport != null && commonSupport.isRemote()) {
            result = false;
        }
        return result;
    }

    public static String getTargetFromUri(String uri) {
        String candidate;
        String target = null;
        int lastColon = uri.lastIndexOf(58);
        if (lastColon != -1 && !Character.isDigit((candidate = uri.substring(lastColon + 1)).charAt(0))) {
            target = candidate;
        }
        return target;
    }
}

