/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.impl;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.StepRequest;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;

public final class StepUtils {
    private static final String STEP_PROP_DEPTH = "originalThreadDepth";

    private StepUtils() {
    }

    public static void markOriginalStepDepth(StepRequest stepRequest, ThreadReference threadReference) {
        try {
            EventRequestWrapper.putProperty(stepRequest, STEP_PROP_DEPTH, ThreadReferenceWrapper.frameCount(threadReference));
        }
        catch (IncompatibleThreadStateException | IllegalThreadStateExceptionWrapper | InternalExceptionWrapper | InvalidStackFrameExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper exception) {
            // empty catch block
        }
    }

    public static int getOriginalStepDepth(StepRequest stepRequest) {
        Object depth;
        try {
            depth = EventRequestWrapper.getProperty(stepRequest, STEP_PROP_DEPTH);
        }
        catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return -1;
        }
        if (depth instanceof Integer) {
            return (Integer)depth;
        }
        return -1;
    }
}

