/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal.download;

import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.transfer.DownloadManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadThread {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadThread.class);
    private final DownloadManager downloadManager;
    private final GetObjectRequest getObjectRequest;
    private final int rangeSize;
    private final byte[] buffer;
    private final Object lock;
    private int objectSize;
    private volatile int writeTo;
    private volatile Throwable error;
    private volatile int readFrom;
    private volatile boolean cancelRequested;
    private volatile boolean threadCancelled;

    public DownloadThread(DownloadManager downloadManager, GetObjectRequest getObjectRequest, byte[] buffer, int rangeSize) {
        assert (rangeSize <= buffer.length);
        this.downloadManager = downloadManager;
        this.getObjectRequest = getObjectRequest;
        this.rangeSize = rangeSize;
        this.buffer = buffer;
        this.lock = new Object();
        this.writeTo = 0;
        this.readFrom = 0;
        this.error = null;
        this.objectSize = Integer.MAX_VALUE;
    }

    public void requestCancel() {
        this.cancelRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] run() throws IOException {
        LOG.debug("Reading the first {} bytes from range '{}' from {}/{}/{}", new Object[]{this.rangeSize, this.getObjectRequest.getRange(), this.getObjectRequest.getNamespaceName(), this.getObjectRequest.getBucketName(), this.getObjectRequest.getObjectName()});
        try {
            GetObjectResponse getObjectResponse = this.downloadManager.getObject_singleThreaded(this.getObjectRequest);
            try {
                LOG.debug("buffer.length = '{}', rangeSize = '{}', contentLength = '{}'", new Object[]{this.buffer.length, this.rangeSize, getObjectResponse.getContentLength()});
                this.objectSize = Math.min(Math.toIntExact(getObjectResponse.getContentLength()), this.rangeSize);
                assert (this.objectSize <= this.buffer.length);
                assert (this.objectSize <= this.rangeSize);
                while (true) {
                    assert (this.writeTo >= this.readFrom);
                    assert (this.writeTo <= this.buffer.length);
                    if (this.cancelRequested) {
                        return this.buffer;
                    }
                    int dataRemaining = this.objectSize - this.writeTo;
                    if (dataRemaining <= 0) {
                        return this.buffer;
                    }
                    int bytesRead = getObjectResponse.getInputStream().read(this.buffer, this.writeTo, dataRemaining);
                    if (bytesRead < 0) {
                        LOG.error("Truncated download. Got {} from read (expected {} bytes remaining)", (Object)bytesRead, (Object)dataRemaining);
                        throw new IOException("Truncated read");
                    }
                    assert (bytesRead > 0);
                    LOG.trace("Read {} bytes from response", (Object)bytesRead);
                    Object object = this.lock;
                    synchronized (object) {
                        this.writeTo += bytesRead;
                        this.lock.notify();
                    }
                }
            }
            finally {
                getObjectResponse.getInputStream().close();
                if (this.cancelRequested) {
                    LOG.warn("Async read was cancelled");
                    Object object = this.lock;
                    synchronized (object) {
                        this.threadCancelled = true;
                        this.lock.notify();
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Asynchronous object read failed", t);
            Object object = this.lock;
            synchronized (object) {
                this.error = t;
                this.lock.notify();
                throw t;
            }
        }
    }

    public boolean allDataRead() {
        return this.readFrom >= this.objectSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        int bufferIndex;
        int dataLength;
        if (len == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            while (!this.threadCancelled && this.error == null && this.readFrom < this.objectSize && this.readFrom >= this.writeTo) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("wait() was interrupted", e);
                }
            }
            if (this.threadCancelled) {
                throw new InterruptedIOException("Async read was cancelled");
            }
            if (this.error != null) {
                throw new IOException("Asynchronous read failed", this.error);
            }
            if (this.readFrom >= this.objectSize) {
                return -1;
            }
            int available = this.writeTo - this.readFrom;
            assert (available > 0);
            dataLength = Math.min(len, available);
            bufferIndex = this.readFrom;
            this.readFrom += dataLength;
        }
        System.arraycopy(this.buffer, bufferIndex, b, off, dataLength);
        LOG.trace("Got {} bytes from buffer", (Object)dataLength);
        return dataLength;
    }
}

