/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.modules.java.j2seplatform.spi.J2SEPlatformDefaultJavadoc;
import org.netbeans.modules.java.j2seplatform.spi.J2SEPlatformDefaultSources;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.platform.support.ForwardingJavaPlatform;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class J2SEPlatformImpl
extends JavaPlatform
implements PropertyChangeListener {
    public static final String PROP_ANT_NAME = "antName";
    public static final String PLATFORM_J2SE = "j2se";
    protected static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    protected static final String PLAT_PROP_ARCH_FOLDER = "platform.arch.folder";
    protected static final String SYSPROP_BOOT_CLASSPATH = "sun.boot.class.path";
    protected static final String SYSPROP_JAVA_CLASS_PATH = "java.class.path";
    protected static final String SYSPROP_JAVA_EXT_PATH = "java.ext.dirs";
    protected static final String SYSPROP_USER_DIR = "user.dir";
    private static final String PROP_NO_DEFAULT_JAVADOC = "no.default.javadoc";
    private static final String DEFAULT_JAVADOC_PROVIDER_PATH = "org-netbeans-api-java/platform/j2seplatform/defaultJavadocProviders/";
    private static final String DEFAULT_SOURCES_PROVIDER_PATH = "org-netbeans-api-java/platform/j2seplatform/defaultSourcesProviders/";
    private static final Logger LOG = Logger.getLogger(J2SEPlatformImpl.class.getName());
    private static final AtomicReference<Lookup.Result<J2SEPlatformDefaultSources>> sourcesRes = new AtomicReference();
    private static final AtomicReference<Lookup.Result<J2SEPlatformDefaultJavadoc>> jdocRes = new AtomicReference();
    private String displayName;
    private Map<String, String> properties;
    private ClassPath sources;
    private List<URL> javadoc;
    private List<URL> installFolders;
    private Reference<ClassPath> bootstrap;
    private Reference<ClassPath> standardLibs;
    private Specification spec;
    private LookupListener[] sourcesListener;
    private LookupListener[] jdocListener;
    private final AtomicReference<Boolean> bootValidCache = new AtomicReference();
    private final AtomicBoolean bootValidListens = new AtomicBoolean();

    J2SEPlatformImpl(String dispName, List<URL> installFolders, Map<String, String> initialProperties, Map<String, String> sysProperties, List<URL> sources, List<URL> javadoc) {
        this.displayName = dispName;
        if (installFolders != null) {
            this.installFolders = installFolders;
        } else {
            String home = initialProperties.remove("platform.home");
            if (home != null) {
                this.installFolders = new ArrayList<URL>();
                StringTokenizer tk = new StringTokenizer(home, File.pathSeparator);
                while (tk.hasMoreTokens()) {
                    File f = new File(tk.nextToken());
                    try {
                        this.installFolders.add(Utilities.toURI((File)f).toURL());
                    }
                    catch (MalformedURLException mue) {
                        LOG.log(Level.INFO, null, mue);
                    }
                }
            } else {
                throw new IllegalArgumentException("Invalid platform, platform must have install folder.");
            }
        }
        this.properties = initialProperties;
        if (sources != null) {
            this.sources = J2SEPlatformImpl.createClassPath(sources);
        }
        if (javadoc != null) {
            this.javadoc = Collections.unmodifiableList(javadoc);
        }
        this.setSystemProperties(sysProperties);
    }

    protected J2SEPlatformImpl(String dispName, String antName, List<URL> installFolders, Map<String, String> initialProperties, Map<String, String> sysProperties, List<URL> sources, List<URL> javadoc) {
        this(dispName, installFolders, initialProperties, sysProperties, sources, javadoc);
        this.properties.put(PLAT_PROP_ANT_NAME, antName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        this.firePropertyChange("displayName", null, null);
    }

    protected final void internalSetDisplayName(String name) {
        this.displayName = name;
    }

    public String getAntName() {
        return this.properties.get(PLAT_PROP_ANT_NAME);
    }

    public void setAntName(String antName) {
        if (antName == null || antName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.put(PLAT_PROP_ANT_NAME, antName);
        this.firePropertyChange(PROP_ANT_NAME, null, null);
    }

    public void setArchFolder(String folder) {
        if (folder == null || folder.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.put(PLAT_PROP_ARCH_FOLDER, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ClassPath getBootstrapLibraries() {
        J2SEPlatformImpl j2SEPlatformImpl = this;
        synchronized (j2SEPlatformImpl) {
            ClassPath cp;
            ClassPath classPath = cp = this.bootstrap == null ? null : this.bootstrap.get();
            if (cp != null) {
                return cp;
            }
            if (Util.JDK9.compareTo(this.getSpecification().getVersion()) <= 0) {
                cp = Util.createModulePath(this.getInstallFolders());
            }
            if (cp == null) {
                String extPathSpec;
                Object pathSpec = (String)this.getSystemProperties().get(SYSPROP_BOOT_CLASSPATH);
                if (pathSpec == null) {
                    LOG.log(Level.WARNING, "No sun.boot.class.path property in platform {0}, broken platform?", this.getDisplayName());
                    pathSpec = "";
                }
                if ((extPathSpec = Util.getExtensions((String)this.getSystemProperties().get(SYSPROP_JAVA_EXT_PATH))) != null) {
                    pathSpec = (String)pathSpec + File.pathSeparator + extPathSpec;
                }
                cp = Util.createClassPath((String)pathSpec);
            }
            this.bootstrap = new SoftReference<ClassPath>(cp);
            return cp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getStandardLibraries() {
        J2SEPlatformImpl j2SEPlatformImpl = this;
        synchronized (j2SEPlatformImpl) {
            ClassPath cp;
            ClassPath classPath = cp = this.standardLibs == null ? null : this.standardLibs.get();
            if (cp != null) {
                return cp;
            }
            String pathSpec = (String)this.getSystemProperties().get(SYSPROP_JAVA_CLASS_PATH);
            cp = pathSpec == null ? ClassPathSupport.createClassPath((URL[])new URL[0]) : Util.createClassPath(pathSpec);
            this.standardLibs = new SoftReference<ClassPath>(cp);
            return cp;
        }
    }

    public final Collection<FileObject> getInstallFolders() {
        return Util.toFileObjects(this.installFolders);
    }

    public final FileObject findTool(String toolName) {
        String archFolder = this.getProperties().get(PLAT_PROP_ARCH_FOLDER);
        FileObject tool = null;
        if (archFolder != null) {
            tool = Util.findTool(toolName, this.getInstallFolders(), archFolder);
        }
        if (tool == null) {
            tool = Util.findTool(toolName, this.getInstallFolders());
        }
        return tool;
    }

    public final ClassPath getSourceFolders() {
        if (this.sources == null) {
            this.sources = J2SEPlatformImpl.createClassPath(this.defaultSources(true));
        }
        return this.sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSourceFolders(ClassPath c) {
        LookupListener listener;
        assert (c != null);
        this.sources = c;
        J2SEPlatformImpl j2SEPlatformImpl = this;
        synchronized (j2SEPlatformImpl) {
            listener = this.sourcesListener == null ? null : this.sourcesListener[1];
            this.sourcesListener = null;
        }
        if (listener != null) {
            J2SEPlatformImpl.getJ2SEPlatformDefaultSources().removeLookupListener(listener);
        }
        this.firePropertyChange("sourceFolders", null, null);
    }

    public final List<URL> getJavadocFolders() {
        if (this.javadoc == null) {
            this.javadoc = this.shouldAddDefaultJavadoc() ? this.defaultJavadoc(true) : Collections.emptyList();
        }
        return this.javadoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setJavadocFolders(List<URL> c) {
        LookupListener listener;
        assert (c != null);
        List<URL> safeCopy = Collections.unmodifiableList(new ArrayList<URL>(c));
        for (URL url : safeCopy) {
            if (Util.isRemote(url) || "jar".equals(url.getProtocol()) || !FileUtil.isArchiveFile((URL)url)) continue;
            throw new IllegalArgumentException("JavadocFolder must be a folder: " + url);
        }
        if (c.isEmpty()) {
            if (J2SEPlatformImpl.toURIList(this.javadoc).equals(J2SEPlatformImpl.toURIList(this.defaultJavadoc()))) {
                this.properties.put(PROP_NO_DEFAULT_JAVADOC, Boolean.TRUE.toString());
            }
        } else {
            this.properties.remove(PROP_NO_DEFAULT_JAVADOC);
        }
        this.javadoc = safeCopy;
        J2SEPlatformImpl j2SEPlatformImpl = this;
        synchronized (j2SEPlatformImpl) {
            listener = this.jdocListener == null ? null : this.jdocListener[1];
            this.jdocListener = null;
        }
        if (listener != null) {
            J2SEPlatformImpl.getJ2SEPlatformDefaultJavadoc().removeLookupListener(listener);
        }
        this.firePropertyChange("javadocFolders", null, null);
    }

    public String getVendor() {
        String s = (String)this.getSystemProperties().get("java.vm.vendor");
        return s == null ? "" : s;
    }

    public Specification getSpecification() {
        if (this.spec == null) {
            this.spec = new Specification(PLATFORM_J2SE, Util.getSpecificationVersion(this), NbBundle.getMessage(J2SEPlatformImpl.class, (String)"TXT_J2SEDisplayName"), null);
        }
        return this.spec;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    Collection getInstallFolderURLs() {
        return Collections.unmodifiableList(this.installFolders);
    }

    private static ClassPath createClassPath(List<? extends URL> urls) {
        ArrayList<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>();
        if (urls != null) {
            for (URL uRL : urls) {
                resources.add(ClassPathSupport.createResource((URL)uRL));
            }
        }
        return ClassPathSupport.createClassPath(resources);
    }

    private boolean shouldAddDefaultJavadoc() {
        return !Boolean.parseBoolean(this.getProperties().get(PROP_NO_DEFAULT_JAVADOC));
    }

    @NonNull
    private static List<? extends URI> toURIList(@NonNull List<? extends URL> original) {
        ArrayList<URI> result = new ArrayList<URI>(original.size());
        for (URL uRL : original) {
            try {
                result.add(uRL.toURI());
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    public List<URL> defaultJavadoc() {
        return this.defaultJavadoc(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> defaultJavadoc(boolean listen) {
        ForwardingJavaPlatform safePlatform = new ForwardingJavaPlatform(this){

            public List<URL> getJavadocFolders() {
                return Collections.emptyList();
            }
        };
        LinkedHashSet<URI> roots = new LinkedHashSet<URI>();
        Lookup.Result<? extends J2SEPlatformDefaultJavadoc> res = J2SEPlatformImpl.getJ2SEPlatformDefaultJavadoc();
        if (listen) {
            J2SEPlatformImpl j2SEPlatformImpl = this;
            synchronized (j2SEPlatformImpl) {
                if (this.jdocListener == null) {
                    this.jdocListener = new LookupListener[2];
                    this.jdocListener[0] = new LookupListener(){

                        public void resultChanged(LookupEvent ev) {
                            J2SEPlatformImpl.this.javadoc = null;
                        }
                    };
                    this.jdocListener[1] = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.jdocListener[0], res);
                    res.addLookupListener(this.jdocListener[1]);
                }
            }
        }
        for (J2SEPlatformDefaultJavadoc jdoc : res.allInstances()) {
            roots.addAll(jdoc.getDefaultJavadoc((JavaPlatform)safePlatform));
        }
        ArrayList<URL> result = new ArrayList<URL>(roots.size());
        for (URI root : roots) {
            try {
                result.add(root.toURL());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<URL> defaultSources() {
        return this.defaultSources(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private List<URL> defaultSources(boolean listen) {
        ForwardingJavaPlatform safePlatform = new ForwardingJavaPlatform(this){

            public List<URL> getJavadocFolders() {
                return Collections.emptyList();
            }
        };
        LinkedHashSet<URI> roots = new LinkedHashSet<URI>();
        Lookup.Result<? extends J2SEPlatformDefaultSources> res = J2SEPlatformImpl.getJ2SEPlatformDefaultSources();
        if (listen) {
            J2SEPlatformImpl j2SEPlatformImpl = this;
            synchronized (j2SEPlatformImpl) {
                if (this.sourcesListener == null) {
                    this.sourcesListener = new LookupListener[2];
                    this.sourcesListener[0] = new LookupListener(){

                        public void resultChanged(LookupEvent ev) {
                            J2SEPlatformImpl.this.sources = null;
                        }
                    };
                    this.sourcesListener[1] = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.sourcesListener[0], res);
                    res.addLookupListener(this.sourcesListener[1]);
                }
            }
        }
        for (J2SEPlatformDefaultSources src : res.allInstances()) {
            roots.addAll(src.getDefaultSources((JavaPlatform)safePlatform));
        }
        ArrayList<URL> result = new ArrayList<URL>(roots.size());
        for (URI root : roots) {
            try {
                result.add(root.toURL());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        for (String tool : PlatformConvertor.IMPORTANT_TOOLS) {
            if (this.findTool(tool) != null) continue;
            return false;
        }
        Boolean valid = this.bootValidCache.get();
        if (valid == null) {
            ClassPath boot = this.getBootstrapLibraries();
            if (!this.bootValidListens.get() && this.bootValidListens.compareAndSet(false, true)) {
                boot.addPropertyChangeListener((PropertyChangeListener)this);
            }
            valid = boot.findResource("java/lang/Object.class") != null;
            this.bootValidCache.set(valid);
        }
        return valid;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("entries".equals(evt.getPropertyName())) {
            this.bootValidCache.set(null);
        }
    }

    @NonNull
    private static Lookup.Result<? extends J2SEPlatformDefaultSources> getJ2SEPlatformDefaultSources() {
        Lookup.Result<J2SEPlatformDefaultSources> res = sourcesRes.get();
        if (res == null && !sourcesRes.compareAndSet(null, res = Lookups.forPath((String)DEFAULT_SOURCES_PROVIDER_PATH).lookupResult(J2SEPlatformDefaultSources.class))) {
            res = sourcesRes.get();
        }
        return res;
    }

    @NonNull
    private static Lookup.Result<? extends J2SEPlatformDefaultJavadoc> getJ2SEPlatformDefaultJavadoc() {
        Lookup.Result<J2SEPlatformDefaultJavadoc> res = jdocRes.get();
        if (res == null && !jdocRes.compareAndSet(null, res = Lookups.forPath((String)DEFAULT_JAVADOC_PROVIDER_PATH).lookupResult(J2SEPlatformDefaultJavadoc.class))) {
            res = jdocRes.get();
        }
        return res;
    }
}

