/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.antlr.refactoring;

import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.antlr.refactoring.Bundle;
import org.netbeans.modules.languages.antlr.refactoring.SymbolInformation;
import org.netbeans.modules.languages.antlr.refactoring.WhereUsedRefactoringUIImpl;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public void doFindUsages(Lookup lookup) {
        Runnable start = () -> {
            EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
            if (RefactoringActionsProvider.isFromEditor(ec)) {
                JEditorPane c = ec.getOpenedPanes()[0];
                Document doc = c.getDocument();
                AbstractDocument abstractDoc = doc instanceof AbstractDocument ? (AbstractDocument)doc : null;
                FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                int caretPos = c.getCaretPosition();
                String name = Bundle.NM_Unknown();
                if (abstractDoc != null) {
                    abstractDoc.readLock();
                }
                try {
                    TokenSequence ts = TokenHierarchy.get((Document)doc).tokenSequence();
                    if (ts != null) {
                        ts.move(caretPos);
                        if (ts.moveNext()) {
                            name = ts.token().text().toString();
                        }
                    }
                }
                finally {
                    if (abstractDoc != null) {
                        abstractDoc.readUnlock();
                    }
                }
                SymbolInformation si = new SymbolInformation(file, name);
                UI.openRefactoringUI((RefactoringUI)new WhereUsedRefactoringUIImpl(si), (TopComponent)TopComponent.getRegistry().getActivated());
            }
        };
        SwingUtilities.invokeLater(start);
    }

    static String getActionName(Action action) {
        String arg = (String)action.getValue("Name");
        arg = arg.replace("&", "");
        return arg.replace("...", "");
    }

    public boolean canFindUsages(Lookup lookup) {
        boolean ret = false;
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (ec != null) {
            StyledDocument doc = ec.getDocument();
            if (doc == null) {
                return ret;
            }
            FileObject file = NbEditorUtilities.getFileObject((Document)doc);
            ret = "text/x-antlr3".equals(file.getMIMEType()) || "text/x-antlr4".equals(file.getMIMEType());
        }
        return ret;
    }

    public static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && NbDocument.findRecentEditorPane((EditorCookie)ec) != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }
}

