/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.installations;

import java.io.File;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class WindowsStandaloneInstallation
implements Installation {
    static final File DEFAULT_BASE_PATH = FileUtil.normalizeFile((File)new File("C:/Program Files/MySQL/"));
    static final String FOLDER_NAME_PREFIX = "MySQL Server ";
    private final File basePath;

    protected WindowsStandaloneInstallation(String folderName) {
        this.basePath = new File(DEFAULT_BASE_PATH, folderName);
    }

    @Override
    public String[] getStartCommand() {
        return new String[]{new File(this.basePath, "/bin/mysqld.exe").getAbsolutePath(), "--console"};
    }

    @Override
    public String[] getStopCommand() {
        return new String[]{new File(this.basePath, "/bin/mysqladmin.exe").getAbsolutePath(), "-u root shutdown"};
    }

    @Override
    public boolean isInstalled() {
        return Utilities.isWindows() && Utils.isValidExecutable(this.getStartCommand()[0]);
    }

    @Override
    public boolean isStackInstall() {
        return false;
    }

    @Override
    public String[] getAdminCommand() {
        return new String[]{"", ""};
    }

    @Override
    public String getDefaultPort() {
        return "3306";
    }

    public Installation getInstallation(String command, Installation.Command cmdType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return "Windows Installation - " + this.basePath;
    }
}

