/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.model.ListDataModel;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.context.RequestContext;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.model.ChainedBeanPropertyComparator;
import org.primefaces.model.DynamicChainedPropertyComparator;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

public class SortFeature
implements DataTableFeature {
    private boolean isSortRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_sorting");
    }

    public void decode(FacesContext context, DataTable table) {
        table.setRowIndex(-1);
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String sortKey = (String)params.get(clientId + "_sortKey");
        String sortDir = (String)params.get(clientId + "_sortDir");
        if (table.isMultiSort()) {
            ArrayList<SortMeta> multiSortMeta = new ArrayList<SortMeta>();
            String[] sortKeys = sortKey.split(",");
            String[] sortOrders = sortDir.split(",");
            for (int i = 0; i < sortKeys.length; ++i) {
                String sortField;
                UIColumn sortColumn = table.findColumn(sortKeys[i]);
                ValueExpression columnSortByVE = sortColumn.getValueExpression("sortBy");
                if (sortColumn.isDynamic()) {
                    ((DynamicColumn)sortColumn).applyStatelessModel();
                    Object sortByProperty = sortColumn.getSortBy();
                    String field = sortColumn.getField();
                    sortField = field == null ? (sortByProperty == null ? table.resolveDynamicField(columnSortByVE) : sortByProperty.toString()) : field;
                } else {
                    String field = sortColumn.getField();
                    sortField = field == null ? (columnSortByVE == null ? (String)sortColumn.getSortBy() : table.resolveStaticField(columnSortByVE)) : field;
                }
                multiSortMeta.add(new SortMeta(sortColumn, sortField, SortOrder.valueOf(this.convertSortOrderParam(sortOrders[i])), sortColumn.getSortFunction()));
            }
            table.setMultiSortMeta(multiSortMeta);
        } else {
            UIColumn sortColumn = table.findColumn(sortKey);
            ValueExpression sortByVE = sortColumn.getValueExpression("sortBy");
            if (sortColumn.isDynamic()) {
                ((DynamicColumn)sortColumn).applyStatelessModel();
                Object sortBy = sortColumn.getSortBy();
                if (sortBy == null) {
                    table.setValueExpression("sortBy", sortByVE);
                } else {
                    table.setSortBy(sortBy);
                }
            } else if (sortByVE != null) {
                table.setValueExpression("sortBy", sortByVE);
            } else {
                table.setSortBy(sortColumn.getSortBy());
            }
            table.setSortColumn(sortColumn);
            table.setSortFunction(sortColumn.getSortFunction());
            table.setSortOrder(this.convertSortOrderParam(sortDir));
        }
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        table.setFirst(0);
        if (table.isLazy()) {
            table.loadLazyData();
        } else {
            RequestContext requestContext;
            if (table.isMultiSort()) {
                this.multiSort(context, table);
            } else {
                this.singleSort(context, table);
            }
            if (table.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", table.getRowCount());
            }
        }
        renderer.encodeTbody(context, table, true);
    }

    private ValueExpression createValueExpression(FacesContext context, String var, Object sortBy) {
        ELContext elContext = context.getELContext();
        return context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + var + "." + sortBy + "}", Object.class);
    }

    public void singleSort(FacesContext context, DataTable table) {
        ValueExpression sortByVE;
        Object value = table.getValue();
        if (value == null) {
            return;
        }
        ValueExpression tableSortByVE = table.getValueExpression("sortBy");
        if (tableSortByVE != null) {
            sortByVE = tableSortByVE;
            UIColumn sortColumn = table.getSortColumn();
            if (sortColumn != null && sortColumn.isDynamic()) {
                ((DynamicColumn)sortColumn).applyStatelessModel();
            }
        } else {
            sortByVE = this.createValueExpression(context, table.getVar(), table.getSortBy());
        }
        SortOrder sortOrder = SortOrder.valueOf(table.getSortOrder().toUpperCase(Locale.ENGLISH));
        MethodExpression sortFunction = table.getSortFunction();
        List list = null;
        if (value instanceof List) {
            list = (List)value;
        } else if (value instanceof ListDataModel) {
            list = (List)((ListDataModel)value).getWrappedData();
        } else {
            throw new FacesException("Data type should be java.util.List or javax.faces.model.ListDataModel instance to be sortable.");
        }
        Collections.sort(list, new BeanPropertyComparator(sortByVE, table.getVar(), sortOrder, sortFunction, table.isCaseSensitiveSort(), table.resolveDataLocale()));
    }

    public void multiSort(FacesContext context, DataTable table) {
        Object value = table.getValue();
        List<SortMeta> sortMeta = table.getMultiSortMeta();
        List list = null;
        boolean caseSensitiveSort = table.isCaseSensitiveSort();
        Locale locale = table.resolveDataLocale();
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            list = (List)value;
        } else if (value instanceof ListDataModel) {
            list = (List)((ListDataModel)value).getWrappedData();
        } else {
            throw new FacesException("Data type should be java.util.List or javax.faces.model.ListDataModel instance to be sortable.");
        }
        ChainedBeanPropertyComparator chainedComparator = new ChainedBeanPropertyComparator();
        for (SortMeta meta : sortMeta) {
            BeanPropertyComparator comparator;
            ValueExpression sortByVE;
            UIColumn sortColumn = meta.getColumn();
            ValueExpression columnSortByVE = sortColumn.getValueExpression("sortBy");
            if (sortColumn.isDynamic()) {
                ((DynamicColumn)sortColumn).applyStatelessModel();
                Object sortByProperty = sortColumn.getSortBy();
                if (sortByProperty == null) {
                    sortByVE = columnSortByVE;
                    comparator = new DynamicChainedPropertyComparator((DynamicColumn)sortColumn, sortByVE, table.getVar(), meta.getSortOrder(), sortColumn.getSortFunction(), caseSensitiveSort, locale);
                } else {
                    sortByVE = this.createValueExpression(context, table.getVar(), sortByProperty);
                    comparator = new BeanPropertyComparator(sortByVE, table.getVar(), meta.getSortOrder(), sortColumn.getSortFunction(), caseSensitiveSort, locale);
                }
            } else {
                sortByVE = columnSortByVE != null ? columnSortByVE : this.createValueExpression(context, table.getVar(), sortColumn.getSortBy());
                comparator = new BeanPropertyComparator(sortByVE, table.getVar(), meta.getSortOrder(), sortColumn.getSortFunction(), caseSensitiveSort, locale);
            }
            chainedComparator.addComparator(comparator);
        }
        Collections.sort(list, chainedComparator);
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return this.isSortRequest(context, table);
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isSortRequest(context, table);
    }

    public String convertSortOrderParam(String order) {
        String sortOrder = null;
        int orderNumber = Integer.parseInt(order);
        switch (orderNumber) {
            case 0: {
                sortOrder = "UNSORTED";
                break;
            }
            case 1: {
                sortOrder = "ASCENDING";
                break;
            }
            case -1: {
                sortOrder = "DESCENDING";
            }
        }
        return sortOrder;
    }
}

