/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.exceptions;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsViewSupport;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.ImageUtilities;

abstract class ExceptionsNode
extends CCTNode {
    private static final ExceptionsNode[] NO_NODES = new ExceptionsNode[0];
    private final ExceptionsNode parent;
    private final List<ExceptionsNode> children;
    final String name;
    final Icon icon;
    long count = 0L;
    Duration duration;
    Duration durationMax;

    ExceptionsNode(String name, Icon icon, ExceptionsNode parent, List<ExceptionsNode> children) {
        this.parent = parent;
        this.children = children;
        this.name = name;
        this.icon = icon;
    }

    final void processData(Duration duration) {
        if (this.parent != null) {
            ++this.count;
            if (duration != null) {
                this.duration = this.duration == null ? duration : this.duration.plus(duration);
                if (this.durationMax == null || this.durationMax.compareTo(duration) < 0) {
                    this.durationMax = duration;
                }
            }
            this.parent.processData(duration);
        } else if (duration != null && this instanceof Root) {
            ((Root)this).tracksDuration = true;
        }
    }

    ExceptionsNode getChild(String name) {
        if (this.children != null) {
            for (ExceptionsNode child : this.children) {
                if (!Objects.equals(name, child.name)) continue;
                return child;
            }
        }
        return null;
    }

    public ExceptionsNode getChild(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public ExceptionsNode[] getChildren() {
        return this.children == null ? NO_NODES : this.children.toArray(NO_NODES);
    }

    public int getIndexOfChild(Object child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public int getNChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public ExceptionsNode getParent() {
        return this.parent;
    }

    protected void addChild(ExceptionsNode child) {
        if (this.children != null) {
            this.children.add(child);
        }
    }

    protected void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExceptionsNode)) {
            return false;
        }
        return Objects.equals(this.name, ((ExceptionsNode)((Object)o)).name);
    }

    public String toString() {
        return this.name;
    }

    static final class Root
    extends ExceptionsNode
    implements JFREventVisitor {
        private final int mode;
        private final ExceptionsViewSupport.Aggregation primary;
        private final ExceptionsViewSupport.Aggregation secondary;
        boolean tracksDuration = false;
        private Boolean durationMode;

        Root() {
            this(0, null, null);
        }

        Root(int mode, ExceptionsViewSupport.Aggregation primary, ExceptionsViewSupport.Aggregation secondary) {
            super(null, null, null, (List<ExceptionsNode>)(primary == null && secondary == null ? null : new ArrayList<ExceptionsNode>()));
            this.mode = mode;
            this.primary = primary;
            this.secondary = ExceptionsViewSupport.Aggregation.NONE.equals((Object)secondary) ? null : secondary;
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            Boolean rw = this.mode != 2 && "jdk.JavaErrorThrow".equals(typeName) ? Boolean.FALSE : (this.mode != 1 && "jdk.JavaExceptionThrow".equals(typeName) ? Boolean.TRUE : null);
            if (rw != null) {
                ExceptionsNode primaryNode;
                String primaryName = Root.getName(this.primary, event);
                if (primaryName == null) {
                    primaryName = "<unknown>";
                }
                if ((primaryNode = this.getChild(primaryName)) == null) {
                    primaryNode = this.createNode(primaryName, this.primary, this, this.secondary == null);
                    this.addChild(primaryNode);
                }
                if (this.secondary != null) {
                    Duration eventDuration;
                    ExceptionsNode secondaryNode;
                    String secondaryName = Root.getName(this.secondary, event);
                    if (secondaryName == null) {
                        secondaryName = "<unknown>";
                    }
                    if ((secondaryNode = primaryNode.getChild(secondaryName)) == null) {
                        secondaryNode = this.createNode(secondaryName, this.secondary, primaryNode, true);
                        primaryNode.addChild(secondaryNode);
                    }
                    try {
                        eventDuration = this.getDuration(event);
                    }
                    catch (JFRPropertyNotAvailableException e) {
                        eventDuration = null;
                    }
                    secondaryNode.processData(eventDuration);
                } else {
                    Duration eventDuration;
                    try {
                        eventDuration = this.getDuration(event);
                    }
                    catch (JFRPropertyNotAvailableException e) {
                        eventDuration = null;
                    }
                    primaryNode.processData(eventDuration);
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 37;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Root;
        }

        private Duration getDuration(JFREvent event) throws JFRPropertyNotAvailableException {
            if (Boolean.TRUE.equals(this.durationMode)) {
                return event.getDuration("eventDuration");
            }
            if (Boolean.FALSE.equals(this.durationMode)) {
                return null;
            }
            try {
                Duration eventDuration = event.getDuration("eventDuration");
                this.durationMode = Boolean.TRUE;
                return eventDuration;
            }
            catch (JFRPropertyNotAvailableException e) {
                this.durationMode = Boolean.FALSE;
                return null;
            }
        }

        private static String getName(ExceptionsViewSupport.Aggregation aggregation, JFREvent event) {
            try {
                if (ExceptionsViewSupport.Aggregation.CLASS.equals((Object)aggregation)) {
                    return Root.decodeClassName(event.getClass("thrownClass").getName());
                }
                if (ExceptionsViewSupport.Aggregation.MESSAGE.equals((Object)aggregation)) {
                    return Root.decodeMessage(event.getString("message"));
                }
                if (ExceptionsViewSupport.Aggregation.CLASS_MESSAGE.equals((Object)aggregation)) {
                    return Root.decodeClassName(event.getClass("thrownClass").getName()) + " : " + Root.decodeMessage(event.getString("message"));
                }
                if (ExceptionsViewSupport.Aggregation.THREAD.equals((Object)aggregation)) {
                    return event.getThread("eventThread").getName();
                }
            }
            catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                // empty catch block
            }
            return null;
        }

        private ExceptionsNode createNode(String name, ExceptionsViewSupport.Aggregation aggregation, ExceptionsNode parent, boolean terminal) {
            if (ExceptionsViewSupport.Aggregation.CLASS.equals((Object)aggregation)) {
                return new Class(name, parent, terminal);
            }
            if (ExceptionsViewSupport.Aggregation.MESSAGE.equals((Object)aggregation)) {
                return new Exception(name, parent, terminal);
            }
            if (ExceptionsViewSupport.Aggregation.CLASS_MESSAGE.equals((Object)aggregation)) {
                return new Class(name, parent, terminal);
            }
            if (ExceptionsViewSupport.Aggregation.THREAD.equals((Object)aggregation)) {
                return new Thread(name, parent, terminal);
            }
            return null;
        }

        private static String decodeClassName(String className) {
            if ((className = StringUtils.userFormClassName((String)className)).startsWith("L") && className.contains(";")) {
                className = className.substring(1).replace(";", "");
            }
            return className;
        }

        private static String decodeMessage(String message) {
            return message == null || message.isEmpty() ? "<no message>" : message;
        }
    }

    static final class Label
    extends ExceptionsNode {
        Label(String label, ExceptionsNode parent) {
            super(label, null, parent, null);
        }

        static Label createNoData(ExceptionsNode parent) {
            return new Label("<no data>", parent);
        }
    }

    static final class Thread
    extends ExceptionsNode {
        Thread(String name, ExceptionsNode parent, boolean terminal) {
            super(name, Icons.getIcon((String)"ProfilerIcons.Thread"), parent, terminal ? null : new ArrayList());
        }
    }

    static final class Exception
    extends ExceptionsNode {
        private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/exception.png";
        private static final Icon ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/jfr/resources/exception.png", (boolean)true));

        Exception(String name, ExceptionsNode parent, boolean terminal) {
            super(name, ICON, parent, terminal ? null : new ArrayList());
        }
    }

    static final class Error
    extends ExceptionsNode {
        private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/error.png";
        private static final Icon ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/jfr/resources/error.png", (boolean)true));

        Error(String name, ExceptionsNode parent, boolean terminal) {
            super(name, ICON, parent, terminal ? null : new ArrayList());
        }
    }

    static final class Class
    extends ExceptionsNode {
        Class(String name, ExceptionsNode parent, boolean terminal) {
            super(name, Icons.getIcon((String)"LanguageIcons.Class"), parent, terminal ? null : new ArrayList());
        }
    }
}

