/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.locks;

import java.awt.AWTKeyStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockRuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.FlatToolBar;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.components.table.LabelBracketTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelTableCellRenderer;
import org.graalvm.visualvm.lib.ui.locks.LockContentionRenderer;
import org.graalvm.visualvm.lib.ui.results.DataView;
import org.graalvm.visualvm.lib.ui.swing.PopupButton;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.SearchUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.McsTimeRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberPercentRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;

public abstract class LockContentionPanel
extends DataView {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.locks.Bundle");
    private static final String ENABLE_LOCKS_MONITORING = messages.getString("LockContentionPanel_EnableLocksMonitoring");
    private static final String ENABLE_LOCKS_MONITORING_TOOLTIP = messages.getString("LockContentionPanel_EnableLocksMonitoringToolTip");
    private static final String NO_PROFILING = messages.getString("LockContentionPanel_NoProfiling");
    private static final String LOCKS_THREADS_COLUMN_NAME = messages.getString("LockContentionPanel_LocksThreadsColumnName");
    private static final String LOCKS_THREADS_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_LocksThreadsColumnToolTip");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("LockContentionPanel_TimeRelColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_TimeRelColumnToolTip");
    private static final String WAITS_COLUMN_NAME = messages.getString("LockContentionPanel_WaitsColumnName");
    private static final String WAITS_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_WaitsColumnToolTip");
    private static final String DISPLAY_MODE = messages.getString("LockContentionPanel_DisplayMode");
    private static final String MODE_THREADS = messages.getString("LockContentionPanel_ModeThreads");
    private static final String MODE_MONITORS = messages.getString("LockContentionPanel_ModeMonitors");
    private static final String SEARCH_THREADS_SCOPE = messages.getString("LockContentionPanel_SearchThreadsScope");
    private static final String SEARCH_MONITORS_SCOPE = messages.getString("LockContentionPanel_SearchMonitorsScope");
    private static final String SEARCH_SCOPE_TOOLTIP = messages.getString("LockContentionPanel_SearchScopeTooltip");
    private boolean refreshIsRunning;
    private final ProfilerToolbar toolbar;
    private final LocksTreeTableModel treeTableModel;
    private final ProfilerTreeTable treeTable;
    private final ProfilerTableContainer treeTablePanel;
    private final JComboBox modeCombo;
    private int columnCount;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private Aggregation aggregation = Aggregation.BY_THREADS;
    private final JPanel contentPanel;
    private final JPanel notificationPanel;
    private final JButton enableLockContentionButton;
    private final JLabel enableLockContentionLabel1;
    private final JLabel enableLockContentionLabel2;
    private LockRuntimeCCTNode root;
    private long countsInMicrosec = 1L;
    private final HideableBarRenderer hbrTime;
    private final HideableBarRenderer hbrWaits;
    private long lastupdate;
    private boolean searchThreads = true;
    private boolean searchMonitors = true;

    public LockContentionPanel() {
        this.toolbar = ProfilerToolbar.create(true);
        JLabel modeLabel = new JLabel(DISPLAY_MODE);
        modeLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.toolbar.add(modeLabel);
        this.modeCombo = new JComboBox(new Object[]{MODE_THREADS, MODE_MONITORS}){

            @Override
            protected void fireActionEvent() {
                super.fireActionEvent();
                LockContentionPanel.this.treeTable.clearSelection();
                LockContentionPanel.this.prepareResults();
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = this.getPreferredSize();
                dim.width += 20;
                return dim;
            }
        };
        this.modeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer dlcr = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (MODE_THREADS.equals(value.toString())) {
                    dlcr.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
                } else if (MODE_MONITORS.equals(value.toString())) {
                    dlcr.setIcon(Icons.getIcon((String)"ProfilerIcons.WindowLocks"));
                }
                return dlcr;
            }
        });
        modeLabel.setLabelFor(this.modeCombo);
        this.toolbar.add(this.modeCombo);
        this.initColumnsData();
        this.treeTableModel = new LocksTreeTableModel();
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{0}){

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                popup.add(this.createCopyMenuItem());
                popup.addSeparator();
                popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        LockContentionPanel.this.activateSearch();
                    }
                });
            }
        };
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.providePopupMenu(true);
        this.treeTable.setMainColumn(0);
        this.treeTable.setFitWidthColumn(0);
        this.treeTable.setSortColumn(1);
        this.treeTable.setDefaultSortOrder(1, SortOrder.DESCENDING);
        LockContentionRenderer lcRenderer = new LockContentionRenderer();
        this.treeTable.setTreeCellRenderer(lcRenderer);
        Long refTime = new Long(123456L);
        NumberPercentRenderer npr = new NumberPercentRenderer(new McsTimeRenderer());
        this.hbrTime = new HideableBarRenderer(npr);
        this.hbrTime.setMaxValue(refTime);
        this.treeTable.setColumnRenderer(1, this.hbrTime);
        this.treeTable.setDefaultColumnWidth(1, this.hbrTime.getOptimalWidth());
        this.hbrWaits = new HideableBarRenderer(new NumberRenderer());
        this.hbrWaits.setMaxValue(1234567L);
        this.treeTable.setColumnRenderer(2, this.hbrWaits);
        this.treeTable.setDefaultColumnWidth(2, this.hbrWaits.getMaxNoBarWidth());
        this.treeTable.setColumnToolTips(new String[]{LOCKS_THREADS_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, WAITS_COLUMN_TOOLTIP});
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, keys);
        this.treeTablePanel = new ProfilerTableContainer(this.treeTable, false, null);
        this.notificationPanel = new JPanel(new FlowLayout(3, 0, 15));
        this.notificationPanel.setBackground(this.treeTable.getBackground());
        UIUtils.decorateProfilerPanel(this.notificationPanel);
        CompoundBorder myRolloverBorder = new CompoundBorder(new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), new FlatToolBar.FlatMarginBorder());
        this.enableLockContentionLabel1 = new JLabel(ENABLE_LOCKS_MONITORING);
        this.enableLockContentionLabel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 3));
        this.enableLockContentionLabel1.setForeground(Color.DARK_GRAY);
        this.enableLockContentionButton = new JButton(Icons.getIcon((String)"ProfilerIcons.ViewLocks32"));
        this.enableLockContentionButton.setToolTipText(ENABLE_LOCKS_MONITORING_TOOLTIP);
        this.enableLockContentionButton.setContentAreaFilled(false);
        this.enableLockContentionButton.setMargin(new Insets(3, 3, 3, 3));
        this.enableLockContentionButton.setVerticalTextPosition(3);
        this.enableLockContentionButton.setHorizontalTextPosition(0);
        this.enableLockContentionButton.setRolloverEnabled(true);
        this.enableLockContentionButton.setBorder(myRolloverBorder);
        this.enableLockContentionButton.getAccessibleContext().setAccessibleName(ENABLE_LOCKS_MONITORING_TOOLTIP);
        this.enableLockContentionLabel2 = new JLabel(NO_PROFILING);
        this.enableLockContentionLabel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        this.enableLockContentionLabel2.setForeground(Color.DARK_GRAY);
        this.enableLockContentionLabel2.setVisible(false);
        this.notificationPanel.add(this.enableLockContentionLabel1);
        this.notificationPanel.add(this.enableLockContentionButton);
        this.notificationPanel.add(this.enableLockContentionLabel2);
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)this.notificationPanel, "DISABLED");
        this.contentPanel.add((Component)this.treeTablePanel, "ENABLED");
        this.contentPanel.setOpaque(true);
        this.contentPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.add((Component)this.contentPanel, "Center");
        this.prepareResults();
        this.registerActions();
    }

    protected abstract ProfilerClient getProfilerClient();

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockContentionPanel.this.activateSearch();
            }
        });
    }

    @Override
    protected SearchUtils.TreeHelper getSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode tnode) {
                LockCCTNode node = (LockCCTNode)tnode;
                LockCCTNode parent = node.getParent();
                if (parent == null) {
                    return 100;
                }
                if (node.isThreadLockNode()) {
                    return LockContentionPanel.this.searchThreads ? 10 : 100;
                }
                if (node.isMonitorNode()) {
                    return LockContentionPanel.this.searchMonitors ? 10 : 100;
                }
                return 100;
            }
        };
    }

    @Override
    protected Component[] getSearchOptions() {
        PopupButton pb = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JCheckBoxMenuItem(SEARCH_THREADS_SCOPE, LockContentionPanel.this.searchThreads){
                    {
                        if (!LockContentionPanel.this.searchMonitors) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        LockContentionPanel.this.searchThreads = !LockContentionPanel.this.searchThreads;
                    }
                });
                popup.add(new JCheckBoxMenuItem(SEARCH_MONITORS_SCOPE, LockContentionPanel.this.searchMonitors){
                    {
                        if (!LockContentionPanel.this.searchThreads) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        LockContentionPanel.this.searchMonitors = !LockContentionPanel.this.searchMonitors;
                    }
                });
            }
        };
        pb.setToolTipText(SEARCH_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), pb};
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    @Override
    protected boolean hasBottomFilterFindMargin() {
        return true;
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
        this.prepareResults();
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }

    public boolean isRefreshing() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final LockRuntimeCCTNode appRootNode) {
        this.refreshIsRunning = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LockContentionPanel.this.root = appRootNode;
            }
        });
        this.prepareResults();
    }

    public void resetData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LockContentionPanel.this.root = null;
                LockContentionPanel.this.treeTableModel.setRoot((TreeNode)LockCCTNode.EMPTY);
            }
        });
    }

    public void addSaveViewAction(AbstractAction saveViewAction) {
        Component actionButton = this.toolbar.add(saveViewAction);
        this.toolbar.remove(actionButton);
        this.toolbar.add(actionButton, 0);
        this.toolbar.add(new JToolBar.Separator(), 1);
    }

    public void addExportAction(AbstractAction exportAction) {
        Component actionButton = this.toolbar.add(exportAction);
        this.toolbar.remove(actionButton);
        this.toolbar.add(actionButton, 0);
    }

    public void prepareResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LockContentionPanel.this.root == null) {
                    LockContentionPanel.this.refreshIsRunning = false;
                    return;
                }
                LockCCTNode newRoot = null;
                switch (LockContentionPanel.this.aggregation) {
                    case BY_THREADS: {
                        newRoot = LockContentionPanel.this.root.getThreads();
                        break;
                    }
                    case BY_MONITORS: {
                        newRoot = LockContentionPanel.this.root.getMonitors();
                    }
                }
                LockContentionPanel.this.hbrTime.setMaxValue(LockContentionPanel.this.getTimeInMicroSec(newRoot));
                LockContentionPanel.this.hbrWaits.setMaxValue(newRoot.getWaits());
                LockContentionPanel.this.treeTableModel.setRoot((TreeNode)newRoot);
                LockContentionPanel.this.lastupdate = System.currentTimeMillis();
                LockContentionPanel.this.refreshIsRunning = false;
            }
        });
    }

    public void lockContentionDisabled() {
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "DISABLED");
    }

    public void lockContentionEnabled() {
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "ENABLED");
    }

    public void addLockContentionListener(ActionListener listener) {
        this.enableLockContentionButton.addActionListener(listener);
    }

    public void removeLockContentionListener(ActionListener listener) {
        this.enableLockContentionButton.removeActionListener(listener);
    }

    private long getTimeInMicroSec(LockCCTNode node) {
        return node.getTime() / this.countsInMicrosec;
    }

    private String getTimeInMillis(LockCCTNode node) {
        long microSec = this.getTimeInMicroSec(node);
        return StringUtils.mcsTimeToString((long)microSec);
    }

    private void initColumnsData() {
        this.columnCount = 3;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = LOCKS_THREADS_COLUMN_NAME;
        this.columnToolTips[0] = LOCKS_THREADS_COLUMN_TOOLTIP;
        this.columnNames[1] = TIME_REL_COLUMN_NAME;
        this.columnToolTips[1] = TIME_REL_COLUMN_TOOLTIP;
        this.columnNames[2] = WAITS_COLUMN_NAME;
        this.columnToolTips[2] = WAITS_COLUMN_TOOLTIP;
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        this.columnRenderers[0] = null;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = new LabelBracketTableCellRenderer(11);
        this.columnWidths[1] = maxWidth;
        this.columnRenderers[2] = new LabelTableCellRenderer(11);
    }

    public Component getToolbar() {
        return this.toolbar.getComponent();
    }

    private class LocksTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        private LocksTreeTableModel() {
            super((TreeNode)LockCCTNode.EMPTY);
        }

        @Override
        public boolean isCellEditable(TreeNode node, int columnIndex) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return JTree.class;
            }
            if (column == 1) {
                return Long.class;
            }
            if (column == 2) {
                return Long.class;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return LockContentionPanel.this.columnCount;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return LockContentionPanel.this.columnNames[columnIndex];
        }

        @Override
        public Object getValueAt(TreeNode node, int columnIndex) {
            LockCCTNode lnode = (LockCCTNode)node;
            switch (columnIndex) {
                case 0: {
                    return lnode;
                }
                case 1: {
                    return LockContentionPanel.this.getTimeInMicroSec(lnode);
                }
                case 2: {
                    return lnode.getWaits();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, TreeNode node, int column) {
        }
    }

    public static enum Aggregation {
        BY_THREADS,
        BY_MONITORS;

    }
}

