/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.host.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.core.properties.PropertiesCustomizer;
import org.graalvm.visualvm.core.properties.PropertiesSupport;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.host.impl.HostProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HostCustomizer
extends JPanel {
    private static Dimension MIN_PROPERTIES_SIZE = new Dimension(400, 200);
    private static Dimension MAX_PROPERTIES_SIZE = new Dimension(700, 400);
    private boolean internalChange = false;
    private static HostCustomizer instance;
    private JLabel hostnameLabel;
    private JTextField hostnameField;
    private JCheckBox displaynameCheckbox;
    private JTextField displaynameField;
    private JPanel settingsContainer;
    private PropertiesCustomizer<Host> settingsPanel;
    private JButton okButton;
    private JToggleButton settingsButton;
    private final ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            HostCustomizer.this.update();
        }
    };

    public static HostProperties defineHost() {
        HostCustomizer hc = HostCustomizer.getInstance();
        hc.setup();
        ScrollableContainer sc = new ScrollableContainer((JComponent)hc, 20, 31);
        sc.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        sc.setViewportBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        DialogDescriptor dd = new DialogDescriptor((Object)sc, NbBundle.getMessage(HostCustomizer.class, (String)"Title_Add_Remote_Host"), true, new Object[]{hc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)hc.okButton, 0, null, null);
        dd.setAdditionalOptions(new Object[]{hc.settingsButton});
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == hc.okButton) {
            HostProperties hp = new HostProperties(hc.getHostName(), hc.getDisplayName(), hc.getPropertiesCustomizer());
            hc.accepted();
            return hp;
        }
        hc.cancelled();
        return null;
    }

    private HostCustomizer() {
        this.initComponents();
        this.update();
    }

    private static HostCustomizer getInstance() {
        if (instance == null) {
            instance = new HostCustomizer();
        }
        return instance;
    }

    private String getHostName() {
        return this.hostnameField.getText().trim();
    }

    private String getDisplayName() {
        return this.displaynameField.getText().trim();
    }

    private PropertiesCustomizer<Host> getPropertiesCustomizer() {
        return this.settingsPanel;
    }

    private void setup() {
        this.hostnameField.setEnabled(true);
        this.displaynameCheckbox.setSelected(false);
        this.displaynameCheckbox.setEnabled(true);
        this.hostnameField.setText("");
        this.displaynameField.setText("");
        PropertiesSupport support = PropertiesSupport.sharedInstance();
        PropertiesCustomizer<Host> propertiesCustomizer = this.settingsPanel = !support.hasProperties(Host.class) ? null : support.getCustomizer(Host.class);
        if (this.settingsPanel != null) {
            this.settingsPanel.addChangeListener(this.listener);
        }
        this.settingsButton.setVisible(this.settingsPanel != null);
        if (!this.settingsButton.isVisible()) {
            this.settingsButton.setSelected(false);
        } else {
            this.settingsButton.setSelected(!this.settingsPanel.settingsValid());
        }
        this.updateSettings();
    }

    private void accepted() {
        this.cleanup();
    }

    private void cancelled() {
        if (this.settingsPanel != null) {
            this.settingsPanel.propertiesCancelled();
        }
        this.cleanup();
    }

    private void cleanup() {
        if (this.settingsPanel != null) {
            this.settingsPanel.removeChangeListener(this.listener);
        }
        this.settingsContainer.removeAll();
        this.settingsPanel = null;
    }

    private void update() {
        if (this.internalChange) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String hostname = HostCustomizer.this.getHostName();
                if (!HostCustomizer.this.displaynameCheckbox.isSelected()) {
                    HostCustomizer.this.internalChange = true;
                    HostCustomizer.this.displaynameField.setText(hostname);
                    HostCustomizer.this.internalChange = false;
                }
                String displayname = HostCustomizer.this.getDisplayName();
                HostCustomizer.this.displaynameField.setEnabled(HostCustomizer.this.displaynameCheckbox.isSelected());
                boolean hostValid = !hostname.isEmpty() && !displayname.isEmpty();
                boolean settingsValid = HostCustomizer.this.settingsPanel == null || HostCustomizer.this.settingsPanel.settingsValid();
                HostCustomizer.this.okButton.setEnabled(hostValid && settingsValid);
            }
        });
    }

    private void updateSettings() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HostCustomizer.this.settingsButton.isSelected()) {
                    HostCustomizer.this.settingsContainer.add((Component)HostCustomizer.this.settingsPanel, "Center");
                    HostCustomizer.this.settingsContainer.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
                    Dimension prefSize = HostCustomizer.this.settingsPanel.getPreferredSize();
                    prefSize.height = Math.max(prefSize.height, MIN_PROPERTIES_SIZE.height);
                    prefSize.height = Math.min(prefSize.height, MAX_PROPERTIES_SIZE.height);
                    HostCustomizer.this.settingsPanel.setPreferredSize(prefSize);
                } else {
                    HostCustomizer.this.settingsContainer.removeAll();
                    HostCustomizer.this.settingsContainer.setBorder(BorderFactory.createEmptyBorder());
                }
                Window w = SwingUtilities.getWindowAncestor(HostCustomizer.this);
                if (w != null) {
                    w.pack();
                }
                HostCustomizer.this.update();
            }
        });
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.hostnameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.hostnameLabel, (String)NbBundle.getMessage(HostCustomizer.class, (String)"LBL_Host_name"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.hostnameLabel, constraints);
        this.hostnameField = new JTextField();
        this.hostnameLabel.setLabelFor(this.hostnameField);
        this.hostnameField.setPreferredSize(new Dimension(250, this.hostnameField.getPreferredSize().height));
        this.hostnameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.hostnameField, constraints);
        this.displaynameCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.displaynameCheckbox, (String)NbBundle.getMessage(HostCustomizer.class, (String)"LBL_Display_name"));
        this.displaynameCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostCustomizer.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(8, 0, 5, 0);
        this.add((Component)this.displaynameCheckbox, constraints);
        this.displaynameField = new JTextField();
        this.displaynameField.setPreferredSize(new Dimension(250, this.displaynameField.getPreferredSize().height));
        this.displaynameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 5, 0);
        this.add((Component)this.displaynameField, constraints);
        this.settingsContainer = new JPanel(new BorderLayout(0, 0));
        this.settingsContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.settingsContainer, constraints);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(HostCustomizer.class, (String)"LBL_OK"));
        this.settingsButton = new JToggleButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                HostCustomizer.this.updateSettings();
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)this.settingsButton, (String)NbBundle.getMessage(HostCustomizer.class, (String)"BTN_AdvancedSettings"));
        this.displaynameCheckbox.setBorder(this.hostnameLabel.getBorder());
    }
}

