/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public final class ScrollableContainer
extends JScrollPane {
    public ScrollableContainer(JComponent view) {
        this(view, 20, 30);
    }

    public ScrollableContainer(JComponent view, int vsbPolicy, int hsbPolicy) {
        this.setViewportView(new ScrollableContents(view));
        this.setVerticalScrollBarPolicy(vsbPolicy);
        this.setHorizontalScrollBarPolicy(hsbPolicy);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        this.getViewport().setOpaque(false);
        this.setOpaque(false);
    }

    private class ScrollableContents
    extends JPanel
    implements Scrollable {
        ScrollableContents(JComponent contents) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.add((Component)contents, "Center");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (int)((double)visibleRect.height * 0.9);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (ScrollableContainer.this.getHorizontalScrollBarPolicy() == 31) {
                return true;
            }
            Container parent = this.getParent();
            if (!(parent instanceof JViewport)) {
                return false;
            }
            return this.getMinimumSize().width < parent.getWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            if (ScrollableContainer.this.getVerticalScrollBarPolicy() == 21) {
                return true;
            }
            Container parent = this.getParent();
            if (!(parent instanceof JViewport)) {
                return false;
            }
            return this.getMinimumSize().height < parent.getHeight();
        }
    }
}

